package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Represents a request for logs.
 */
@Generated(from = "_ApplicationLogsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ApplicationLogsRequest
    extends org.cloudfoundry.operations.applications._ApplicationLogsRequest {
  private final String name;
  private final @Nullable Boolean recent;

  private ApplicationLogsRequest(ApplicationLogsRequest.Builder builder) {
    this.name = builder.name;
    this.recent = builder.recent;
  }

  /**
   * The name of the application
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * Whether only recent logs should be retrieved
   */
  @Override
  public @Nullable Boolean getRecent() {
    return recent;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationLogsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationLogsRequest
        && equalTo(0, (ApplicationLogsRequest) another);
  }

  private boolean equalTo(int synthetic, ApplicationLogsRequest another) {
    return name.equals(another.name)
        && Objects.equals(recent, another.recent);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code recent}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(recent);
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationLogsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationLogsRequest{"
        + "name=" + name
        + ", recent=" + recent
        + "}";
  }

  /**
   * Creates a builder for {@link ApplicationLogsRequest ApplicationLogsRequest}.
   * <pre>
   * ApplicationLogsRequest.builder()
   *    .name(String) // required {@link ApplicationLogsRequest#getName() name}
   *    .recent(Boolean | null) // nullable {@link ApplicationLogsRequest#getRecent() recent}
   *    .build();
   * </pre>
   * @return A new ApplicationLogsRequest builder
   */
  public static ApplicationLogsRequest.Builder builder() {
    return new ApplicationLogsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationLogsRequest ApplicationLogsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ApplicationLogsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;
    private Boolean recent;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationLogsRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationLogsRequest instance) {
      return from((_ApplicationLogsRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationLogsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationLogsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      Boolean recentValue = instance.getRecent();
      if (recentValue != null) {
        recent(recentValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationLogsRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationLogsRequest#getRecent() recent} attribute.
     * @param recent The value for recent (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder recent(@Nullable Boolean recent) {
      this.recent = recent;
      return this;
    }

    /**
     * Builds a new {@link ApplicationLogsRequest ApplicationLogsRequest}.
     * @return An immutable instance of ApplicationLogsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationLogsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ApplicationLogsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build ApplicationLogsRequest, some of required attributes are not set " + attributes;
    }
  }
}
