package org.cloudfoundry.operations.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request options for the push application operation
 */
@Generated(from = "_PushManifestV3Request", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class PushManifestV3Request
    extends org.cloudfoundry.operations.applications._PushManifestV3Request {
  private final ManifestV3 manifest;

  private PushManifestV3Request(PushManifestV3Request.Builder builder) {
    this.manifest = builder.manifest;
  }

  /**
   * @return The value of the {@code manifest} attribute
   */
  @Override
  public ManifestV3 getManifest() {
    return manifest;
  }

  /**
   * This instance is equal to all instances of {@code PushManifestV3Request} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof PushManifestV3Request
        && equalTo(0, (PushManifestV3Request) another);
  }

  private boolean equalTo(int synthetic, PushManifestV3Request another) {
    return manifest.equals(another.manifest);
  }

  /**
   * Computes a hash code from attributes: {@code manifest}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + manifest.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PushManifestV3Request} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PushManifestV3Request{"
        + "manifest=" + manifest
        + "}";
  }

  /**
   * Creates a builder for {@link PushManifestV3Request PushManifestV3Request}.
   * <pre>
   * PushManifestV3Request.builder()
   *    .manifest(org.cloudfoundry.operations.applications.ManifestV3) // required {@link PushManifestV3Request#getManifest() manifest}
   *    .build();
   * </pre>
   * @return A new PushManifestV3Request builder
   */
  public static PushManifestV3Request.Builder builder() {
    return new PushManifestV3Request.Builder();
  }

  /**
   * Builds instances of type {@link PushManifestV3Request PushManifestV3Request}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_PushManifestV3Request", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MANIFEST = 0x1L;
    private long initBits = 0x1L;

    private ManifestV3 manifest;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PushManifestV3Request} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PushManifestV3Request instance) {
      return from((_PushManifestV3Request) instance);
    }

    /**
     * Copy abstract value type {@code _PushManifestV3Request} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_PushManifestV3Request instance) {
      Objects.requireNonNull(instance, "instance");
      this.manifest(instance.getManifest());
      return this;
    }

    /**
     * Initializes the value for the {@link PushManifestV3Request#getManifest() manifest} attribute.
     * @param manifest The value for manifest 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder manifest(ManifestV3 manifest) {
      this.manifest = Objects.requireNonNull(manifest, "manifest");
      initBits &= ~INIT_BIT_MANIFEST;
      return this;
    }

    /**
     * Builds a new {@link PushManifestV3Request PushManifestV3Request}.
     * @return An immutable instance of PushManifestV3Request
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PushManifestV3Request build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new PushManifestV3Request(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MANIFEST) != 0) attributes.add("manifest");
      return "Cannot build PushManifestV3Request, some of required attributes are not set " + attributes;
    }
  }
}
