package org.cloudfoundry.operations.buildpacks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * A Cloud Foundry Buildpack
 */
@Generated(from = "_Buildpack", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Buildpack extends org.cloudfoundry.operations.buildpacks._Buildpack {
  private final Boolean enabled;
  private final @Nullable String filename;
  private final String id;
  private final Boolean locked;
  private final String name;
  private final Integer position;
  private final @Nullable String stack;

  private Buildpack(Buildpack.Builder builder) {
    this.enabled = builder.enabled;
    this.filename = builder.filename;
    this.id = builder.id;
    this.locked = builder.locked;
    this.name = builder.name;
    this.position = builder.position;
    this.stack = builder.stack;
  }

  /**
   * The enabled flag
   */
  @Override
  public Boolean getEnabled() {
    return enabled;
  }

  /**
   * The filename
   */
  @Override
  public @Nullable String getFilename() {
    return filename;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The locked flag
   */
  @Override
  public Boolean getLocked() {
    return locked;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The position
   */
  @Override
  public Integer getPosition() {
    return position;
  }

  /**
   * The stack
   */
  @Override
  public @Nullable String getStack() {
    return stack;
  }

  /**
   * This instance is equal to all instances of {@code Buildpack} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Buildpack
        && equalTo(0, (Buildpack) another);
  }

  private boolean equalTo(int synthetic, Buildpack another) {
    return enabled.equals(another.enabled)
        && Objects.equals(filename, another.filename)
        && id.equals(another.id)
        && locked.equals(another.locked)
        && name.equals(another.name)
        && position.equals(another.position)
        && Objects.equals(stack, another.stack);
  }

  /**
   * Computes a hash code from attributes: {@code enabled}, {@code filename}, {@code id}, {@code locked}, {@code name}, {@code position}, {@code stack}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + enabled.hashCode();
    h += (h << 5) + Objects.hashCode(filename);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + locked.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + position.hashCode();
    h += (h << 5) + Objects.hashCode(stack);
    return h;
  }

  /**
   * Prints the immutable value {@code Buildpack} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Buildpack{"
        + "enabled=" + enabled
        + ", filename=" + filename
        + ", id=" + id
        + ", locked=" + locked
        + ", name=" + name
        + ", position=" + position
        + ", stack=" + stack
        + "}";
  }

  /**
   * Creates a builder for {@link Buildpack Buildpack}.
   * <pre>
   * Buildpack.builder()
   *    .enabled(Boolean) // required {@link Buildpack#getEnabled() enabled}
   *    .filename(String | null) // nullable {@link Buildpack#getFilename() filename}
   *    .id(String) // required {@link Buildpack#getId() id}
   *    .locked(Boolean) // required {@link Buildpack#getLocked() locked}
   *    .name(String) // required {@link Buildpack#getName() name}
   *    .position(Integer) // required {@link Buildpack#getPosition() position}
   *    .stack(String | null) // nullable {@link Buildpack#getStack() stack}
   *    .build();
   * </pre>
   * @return A new Buildpack builder
   */
  public static Buildpack.Builder builder() {
    return new Buildpack.Builder();
  }

  /**
   * Builds instances of type {@link Buildpack Buildpack}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Buildpack", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ENABLED = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_LOCKED = 0x4L;
    private static final long INIT_BIT_NAME = 0x8L;
    private static final long INIT_BIT_POSITION = 0x10L;
    private long initBits = 0x1fL;

    private Boolean enabled;
    private String filename;
    private String id;
    private Boolean locked;
    private String name;
    private Integer position;
    private String stack;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Buildpack} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Buildpack instance) {
      return from((_Buildpack) instance);
    }

    /**
     * Copy abstract value type {@code _Buildpack} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Buildpack instance) {
      Objects.requireNonNull(instance, "instance");
      this.enabled(instance.getEnabled());
      String filenameValue = instance.getFilename();
      if (filenameValue != null) {
        filename(filenameValue);
      }
      this.id(instance.getId());
      this.locked(instance.getLocked());
      this.name(instance.getName());
      this.position(instance.getPosition());
      String stackValue = instance.getStack();
      if (stackValue != null) {
        stack(stackValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Buildpack#getEnabled() enabled} attribute.
     * @param enabled The value for enabled 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enabled(Boolean enabled) {
      this.enabled = Objects.requireNonNull(enabled, "enabled");
      initBits &= ~INIT_BIT_ENABLED;
      return this;
    }

    /**
     * Initializes the value for the {@link Buildpack#getFilename() filename} attribute.
     * @param filename The value for filename (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder filename(@Nullable String filename) {
      this.filename = filename;
      return this;
    }

    /**
     * Initializes the value for the {@link Buildpack#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Buildpack#getLocked() locked} attribute.
     * @param locked The value for locked 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder locked(Boolean locked) {
      this.locked = Objects.requireNonNull(locked, "locked");
      initBits &= ~INIT_BIT_LOCKED;
      return this;
    }

    /**
     * Initializes the value for the {@link Buildpack#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Buildpack#getPosition() position} attribute.
     * @param position The value for position 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder position(Integer position) {
      this.position = Objects.requireNonNull(position, "position");
      initBits &= ~INIT_BIT_POSITION;
      return this;
    }

    /**
     * Initializes the value for the {@link Buildpack#getStack() stack} attribute.
     * @param stack The value for stack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stack(@Nullable String stack) {
      this.stack = stack;
      return this;
    }

    /**
     * Builds a new {@link Buildpack Buildpack}.
     * @return An immutable instance of Buildpack
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Buildpack build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Buildpack(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ENABLED) != 0) attributes.add("enabled");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_LOCKED) != 0) attributes.add("locked");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_POSITION) != 0) attributes.add("position");
      return "Cannot build Buildpack, some of required attributes are not set " + attributes;
    }
  }
}
