package org.cloudfoundry.operations.buildpacks;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the update buildpack operation
 */
@Generated(from = "_UpdateBuildpackRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateBuildpackRequest
    extends org.cloudfoundry.operations.buildpacks._UpdateBuildpackRequest {
  private final @Nullable Path buildpack;
  private final @Nullable Boolean enable;
  private final @Nullable Boolean lock;
  private final String name;
  private final @Nullable Integer position;

  private UpdateBuildpackRequest(UpdateBuildpackRequest.Builder builder) {
    this.buildpack = builder.buildpack;
    this.enable = builder.enable;
    this.lock = builder.lock;
    this.name = builder.name;
    this.position = builder.position;
  }

  /**
   * The path to the buildpack
   */
  @Override
  public @Nullable Path getBuildpack() {
    return buildpack;
  }

  /**
   * Enables the buildpack to be used for staging
   */
  @Override
  public @Nullable Boolean getEnable() {
    return enable;
  }

  /**
   * Locks the buildpack to prevent changes
   */
  @Override
  public @Nullable Boolean getLock() {
    return lock;
  }

  /**
   * The buildpack name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The buildpack position
   */
  @Override
  public @Nullable Integer getPosition() {
    return position;
  }

  /**
   * This instance is equal to all instances of {@code UpdateBuildpackRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateBuildpackRequest
        && equalTo(0, (UpdateBuildpackRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateBuildpackRequest another) {
    return Objects.equals(buildpack, another.buildpack)
        && Objects.equals(enable, another.enable)
        && Objects.equals(lock, another.lock)
        && name.equals(another.name)
        && Objects.equals(position, another.position);
  }

  /**
   * Computes a hash code from attributes: {@code buildpack}, {@code enable}, {@code lock}, {@code name}, {@code position}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(buildpack);
    h += (h << 5) + Objects.hashCode(enable);
    h += (h << 5) + Objects.hashCode(lock);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(position);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateBuildpackRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateBuildpackRequest{"
        + "buildpack=" + buildpack
        + ", enable=" + enable
        + ", lock=" + lock
        + ", name=" + name
        + ", position=" + position
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateBuildpackRequest UpdateBuildpackRequest}.
   * <pre>
   * UpdateBuildpackRequest.builder()
   *    .buildpack(java.nio.file.Path | null) // nullable {@link UpdateBuildpackRequest#getBuildpack() buildpack}
   *    .enable(Boolean | null) // nullable {@link UpdateBuildpackRequest#getEnable() enable}
   *    .lock(Boolean | null) // nullable {@link UpdateBuildpackRequest#getLock() lock}
   *    .name(String) // required {@link UpdateBuildpackRequest#getName() name}
   *    .position(Integer | null) // nullable {@link UpdateBuildpackRequest#getPosition() position}
   *    .build();
   * </pre>
   * @return A new UpdateBuildpackRequest builder
   */
  public static UpdateBuildpackRequest.Builder builder() {
    return new UpdateBuildpackRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateBuildpackRequest UpdateBuildpackRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateBuildpackRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Path buildpack;
    private Boolean enable;
    private Boolean lock;
    private String name;
    private Integer position;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateBuildpackRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateBuildpackRequest instance) {
      return from((_UpdateBuildpackRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateBuildpackRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateBuildpackRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Path buildpackValue = instance.getBuildpack();
      if (buildpackValue != null) {
        buildpack(buildpackValue);
      }
      Boolean enableValue = instance.getEnable();
      if (enableValue != null) {
        enable(enableValue);
      }
      Boolean lockValue = instance.getLock();
      if (lockValue != null) {
        lock(lockValue);
      }
      this.name(instance.getName());
      Integer positionValue = instance.getPosition();
      if (positionValue != null) {
        position(positionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackRequest#getBuildpack() buildpack} attribute.
     * @param buildpack The value for buildpack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpack(@Nullable Path buildpack) {
      this.buildpack = buildpack;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackRequest#getEnable() enable} attribute.
     * @param enable The value for enable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enable(@Nullable Boolean enable) {
      this.enable = enable;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackRequest#getLock() lock} attribute.
     * @param lock The value for lock (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lock(@Nullable Boolean lock) {
      this.lock = lock;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuildpackRequest#getPosition() position} attribute.
     * @param position The value for position (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder position(@Nullable Integer position) {
      this.position = position;
      return this;
    }

    /**
     * Builds a new {@link UpdateBuildpackRequest UpdateBuildpackRequest}.
     * @return An immutable instance of UpdateBuildpackRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateBuildpackRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateBuildpackRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build UpdateBuildpackRequest, some of required attributes are not set " + attributes;
    }
  }
}
