package org.cloudfoundry.operations.organizationadmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the update quota operation
 */
@Generated(from = "_UpdateQuotaRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateQuotaRequest
    extends org.cloudfoundry.operations.organizationadmin._UpdateQuotaRequest {
  private final @Nullable Boolean allowPaidServicePlans;
  private final @Nullable Integer applicationInstanceLimit;
  private final @Nullable Integer instanceMemoryLimit;
  private final @Nullable Integer memoryLimit;
  private final String name;
  private final @Nullable String newName;
  private final @Nullable Integer totalReservedRoutePorts;
  private final @Nullable Integer totalRoutes;
  private final @Nullable Integer totalServices;

  private UpdateQuotaRequest(UpdateQuotaRequest.Builder builder) {
    this.allowPaidServicePlans = builder.allowPaidServicePlans;
    this.applicationInstanceLimit = builder.applicationInstanceLimit;
    this.instanceMemoryLimit = builder.instanceMemoryLimit;
    this.memoryLimit = builder.memoryLimit;
    this.name = builder.name;
    this.newName = builder.newName;
    this.totalReservedRoutePorts = builder.totalReservedRoutePorts;
    this.totalRoutes = builder.totalRoutes;
    this.totalServices = builder.totalServices;
  }

  /**
   * The allow paid service plans flag
   */
  @Override
  public @Nullable Boolean getAllowPaidServicePlans() {
    return allowPaidServicePlans;
  }

  /**
   * Total number of application instances
   */
  @Override
  public @Nullable Integer getApplicationInstanceLimit() {
    return applicationInstanceLimit;
  }

  /**
   * The instance memory limit
   */
  @Override
  public @Nullable Integer getInstanceMemoryLimit() {
    return instanceMemoryLimit;
  }

  /**
   * The memory limit
   */
  @Override
  public @Nullable Integer getMemoryLimit() {
    return memoryLimit;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The new name
   */
  @Override
  public @Nullable String getNewName() {
    return newName;
  }

  /**
   * Maximum number of routes that may be created with reserved ports
   */
  @Override
  public @Nullable Integer getTotalReservedRoutePorts() {
    return totalReservedRoutePorts;
  }

  /**
   * The total routes
   */
  @Override
  public @Nullable Integer getTotalRoutes() {
    return totalRoutes;
  }

  /**
   * The total services
   */
  @Override
  public @Nullable Integer getTotalServices() {
    return totalServices;
  }

  /**
   * This instance is equal to all instances of {@code UpdateQuotaRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateQuotaRequest
        && equalTo(0, (UpdateQuotaRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateQuotaRequest another) {
    return Objects.equals(allowPaidServicePlans, another.allowPaidServicePlans)
        && Objects.equals(applicationInstanceLimit, another.applicationInstanceLimit)
        && Objects.equals(instanceMemoryLimit, another.instanceMemoryLimit)
        && Objects.equals(memoryLimit, another.memoryLimit)
        && name.equals(another.name)
        && Objects.equals(newName, another.newName)
        && Objects.equals(totalReservedRoutePorts, another.totalReservedRoutePorts)
        && Objects.equals(totalRoutes, another.totalRoutes)
        && Objects.equals(totalServices, another.totalServices);
  }

  /**
   * Computes a hash code from attributes: {@code allowPaidServicePlans}, {@code applicationInstanceLimit}, {@code instanceMemoryLimit}, {@code memoryLimit}, {@code name}, {@code newName}, {@code totalReservedRoutePorts}, {@code totalRoutes}, {@code totalServices}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(allowPaidServicePlans);
    h += (h << 5) + Objects.hashCode(applicationInstanceLimit);
    h += (h << 5) + Objects.hashCode(instanceMemoryLimit);
    h += (h << 5) + Objects.hashCode(memoryLimit);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(newName);
    h += (h << 5) + Objects.hashCode(totalReservedRoutePorts);
    h += (h << 5) + Objects.hashCode(totalRoutes);
    h += (h << 5) + Objects.hashCode(totalServices);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateQuotaRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateQuotaRequest{"
        + "allowPaidServicePlans=" + allowPaidServicePlans
        + ", applicationInstanceLimit=" + applicationInstanceLimit
        + ", instanceMemoryLimit=" + instanceMemoryLimit
        + ", memoryLimit=" + memoryLimit
        + ", name=" + name
        + ", newName=" + newName
        + ", totalReservedRoutePorts=" + totalReservedRoutePorts
        + ", totalRoutes=" + totalRoutes
        + ", totalServices=" + totalServices
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateQuotaRequest UpdateQuotaRequest}.
   * <pre>
   * UpdateQuotaRequest.builder()
   *    .allowPaidServicePlans(Boolean | null) // nullable {@link UpdateQuotaRequest#getAllowPaidServicePlans() allowPaidServicePlans}
   *    .applicationInstanceLimit(Integer | null) // nullable {@link UpdateQuotaRequest#getApplicationInstanceLimit() applicationInstanceLimit}
   *    .instanceMemoryLimit(Integer | null) // nullable {@link UpdateQuotaRequest#getInstanceMemoryLimit() instanceMemoryLimit}
   *    .memoryLimit(Integer | null) // nullable {@link UpdateQuotaRequest#getMemoryLimit() memoryLimit}
   *    .name(String) // required {@link UpdateQuotaRequest#getName() name}
   *    .newName(String | null) // nullable {@link UpdateQuotaRequest#getNewName() newName}
   *    .totalReservedRoutePorts(Integer | null) // nullable {@link UpdateQuotaRequest#getTotalReservedRoutePorts() totalReservedRoutePorts}
   *    .totalRoutes(Integer | null) // nullable {@link UpdateQuotaRequest#getTotalRoutes() totalRoutes}
   *    .totalServices(Integer | null) // nullable {@link UpdateQuotaRequest#getTotalServices() totalServices}
   *    .build();
   * </pre>
   * @return A new UpdateQuotaRequest builder
   */
  public static UpdateQuotaRequest.Builder builder() {
    return new UpdateQuotaRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateQuotaRequest UpdateQuotaRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateQuotaRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Boolean allowPaidServicePlans;
    private Integer applicationInstanceLimit;
    private Integer instanceMemoryLimit;
    private Integer memoryLimit;
    private String name;
    private String newName;
    private Integer totalReservedRoutePorts;
    private Integer totalRoutes;
    private Integer totalServices;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateQuotaRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateQuotaRequest instance) {
      return from((_UpdateQuotaRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateQuotaRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateQuotaRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean allowPaidServicePlansValue = instance.getAllowPaidServicePlans();
      if (allowPaidServicePlansValue != null) {
        allowPaidServicePlans(allowPaidServicePlansValue);
      }
      Integer applicationInstanceLimitValue = instance.getApplicationInstanceLimit();
      if (applicationInstanceLimitValue != null) {
        applicationInstanceLimit(applicationInstanceLimitValue);
      }
      Integer instanceMemoryLimitValue = instance.getInstanceMemoryLimit();
      if (instanceMemoryLimitValue != null) {
        instanceMemoryLimit(instanceMemoryLimitValue);
      }
      Integer memoryLimitValue = instance.getMemoryLimit();
      if (memoryLimitValue != null) {
        memoryLimit(memoryLimitValue);
      }
      this.name(instance.getName());
      String newNameValue = instance.getNewName();
      if (newNameValue != null) {
        newName(newNameValue);
      }
      Integer totalReservedRoutePortsValue = instance.getTotalReservedRoutePorts();
      if (totalReservedRoutePortsValue != null) {
        totalReservedRoutePorts(totalReservedRoutePortsValue);
      }
      Integer totalRoutesValue = instance.getTotalRoutes();
      if (totalRoutesValue != null) {
        totalRoutes(totalRoutesValue);
      }
      Integer totalServicesValue = instance.getTotalServices();
      if (totalServicesValue != null) {
        totalServices(totalServicesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateQuotaRequest#getAllowPaidServicePlans() allowPaidServicePlans} attribute.
     * @param allowPaidServicePlans The value for allowPaidServicePlans (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowPaidServicePlans(@Nullable Boolean allowPaidServicePlans) {
      this.allowPaidServicePlans = allowPaidServicePlans;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateQuotaRequest#getApplicationInstanceLimit() applicationInstanceLimit} attribute.
     * @param applicationInstanceLimit The value for applicationInstanceLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationInstanceLimit(@Nullable Integer applicationInstanceLimit) {
      this.applicationInstanceLimit = applicationInstanceLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateQuotaRequest#getInstanceMemoryLimit() instanceMemoryLimit} attribute.
     * @param instanceMemoryLimit The value for instanceMemoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceMemoryLimit(@Nullable Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = instanceMemoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateQuotaRequest#getMemoryLimit() memoryLimit} attribute.
     * @param memoryLimit The value for memoryLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryLimit(@Nullable Integer memoryLimit) {
      this.memoryLimit = memoryLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateQuotaRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateQuotaRequest#getNewName() newName} attribute.
     * @param newName The value for newName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder newName(@Nullable String newName) {
      this.newName = newName;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateQuotaRequest#getTotalReservedRoutePorts() totalReservedRoutePorts} attribute.
     * @param totalReservedRoutePorts The value for totalReservedRoutePorts (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalReservedRoutePorts(@Nullable Integer totalReservedRoutePorts) {
      this.totalReservedRoutePorts = totalReservedRoutePorts;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateQuotaRequest#getTotalRoutes() totalRoutes} attribute.
     * @param totalRoutes The value for totalRoutes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalRoutes(@Nullable Integer totalRoutes) {
      this.totalRoutes = totalRoutes;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateQuotaRequest#getTotalServices() totalServices} attribute.
     * @param totalServices The value for totalServices (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServices(@Nullable Integer totalServices) {
      this.totalServices = totalServices;
      return this;
    }

    /**
     * Builds a new {@link UpdateQuotaRequest UpdateQuotaRequest}.
     * @return An immutable instance of UpdateQuotaRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateQuotaRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateQuotaRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build UpdateQuotaRequest, some of required attributes are not set " + attributes;
    }
  }
}
