package org.cloudfoundry.operations.routes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * A route and the applications that are bound to the route.
 */
@Generated(from = "_Route", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Route extends org.cloudfoundry.operations.routes._Route {
  private final List<String> applications;
  private final String domain;
  private final String host;
  private final String id;
  private final @Nullable String path;
  private final @Nullable String port;
  private final @Nullable String service;
  private final String space;
  private final @Nullable String type;

  private Route(Route.Builder builder) {
    this.applications = createUnmodifiableList(true, builder.applications);
    this.domain = builder.domain;
    this.host = builder.host;
    this.id = builder.id;
    this.path = builder.path;
    this.port = builder.port;
    this.service = builder.service;
    this.space = builder.space;
    this.type = builder.type;
  }

  /**
   * The applications bound to this route.
   */
  @Override
  public List<String> getApplications() {
    return applications;
  }

  /**
   * The domain of this route
   */
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * The host of this route
   */
  @Override
  public String getHost() {
    return host;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The path of this route
   */
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The port of this route
   */
  @Override
  public @Nullable String getPort() {
    return port;
  }

  /**
   * The service of this route
   */
  @Override
  public @Nullable String getService() {
    return service;
  }

  /**
   * The name of the space of this route
   */
  @Override
  public String getSpace() {
    return space;
  }

  /**
   * The type of this route
   */
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code Route} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Route
        && equalTo(0, (Route) another);
  }

  private boolean equalTo(int synthetic, Route another) {
    return applications.equals(another.applications)
        && domain.equals(another.domain)
        && host.equals(another.host)
        && id.equals(another.id)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port)
        && Objects.equals(service, another.service)
        && space.equals(another.space)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code applications}, {@code domain}, {@code host}, {@code id}, {@code path}, {@code port}, {@code service}, {@code space}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applications.hashCode();
    h += (h << 5) + domain.hashCode();
    h += (h << 5) + host.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + Objects.hashCode(service);
    h += (h << 5) + space.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code Route} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Route{"
        + "applications=" + applications
        + ", domain=" + domain
        + ", host=" + host
        + ", id=" + id
        + ", path=" + path
        + ", port=" + port
        + ", service=" + service
        + ", space=" + space
        + ", type=" + type
        + "}";
  }

  /**
   * Creates a builder for {@link Route Route}.
   * <pre>
   * Route.builder()
   *    .application|addAllApplications(String) // {@link Route#getApplications() applications} elements
   *    .domain(String) // required {@link Route#getDomain() domain}
   *    .host(String) // required {@link Route#getHost() host}
   *    .id(String) // required {@link Route#getId() id}
   *    .path(String | null) // nullable {@link Route#getPath() path}
   *    .port(String | null) // nullable {@link Route#getPort() port}
   *    .service(String | null) // nullable {@link Route#getService() service}
   *    .space(String) // required {@link Route#getSpace() space}
   *    .type(String | null) // nullable {@link Route#getType() type}
   *    .build();
   * </pre>
   * @return A new Route builder
   */
  public static Route.Builder builder() {
    return new Route.Builder();
  }

  /**
   * Builds instances of type {@link Route Route}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Route", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN = 0x1L;
    private static final long INIT_BIT_HOST = 0x2L;
    private static final long INIT_BIT_ID = 0x4L;
    private static final long INIT_BIT_SPACE = 0x8L;
    private long initBits = 0xfL;

    private List<String> applications = new ArrayList<String>();
    private String domain;
    private String host;
    private String id;
    private String path;
    private String port;
    private String service;
    private String space;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Route} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Route instance) {
      return from((_Route) instance);
    }

    /**
     * Copy abstract value type {@code _Route} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Route instance) {
      Objects.requireNonNull(instance, "instance");
      addAllApplications(instance.getApplications());
      this.domain(instance.getDomain());
      this.host(instance.getHost());
      this.id(instance.getId());
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      String portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      String serviceValue = instance.getService();
      if (serviceValue != null) {
        service(serviceValue);
      }
      this.space(instance.getSpace());
      String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link Route#getApplications() applications} list.
     * @param element A applications element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder application(String element) {
      this.applications.add(Objects.requireNonNull(element, "applications element"));
      return this;
    }

    /**
     * Adds elements to {@link Route#getApplications() applications} list.
     * @param elements An array of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applications(String... elements) {
      for (String element : elements) {
        this.applications.add(Objects.requireNonNull(element, "applications element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Route#getApplications() applications} list.
     * @param elements An iterable of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applications(Iterable<String> elements) {
      this.applications.clear();
      return addAllApplications(elements);
    }

    /**
     * Adds elements to {@link Route#getApplications() applications} list.
     * @param elements An iterable of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplications(Iterable<String> elements) {
      for (String element : elements) {
        this.applications.add(Objects.requireNonNull(element, "applications element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Route#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link Route#getHost() host} attribute.
     * @param host The value for host 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(String host) {
      this.host = Objects.requireNonNull(host, "host");
      initBits &= ~INIT_BIT_HOST;
      return this;
    }

    /**
     * Initializes the value for the {@link Route#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Route#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link Route#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable String port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link Route#getService() service} attribute.
     * @param service The value for service (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(@Nullable String service) {
      this.service = service;
      return this;
    }

    /**
     * Initializes the value for the {@link Route#getSpace() space} attribute.
     * @param space The value for space 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder space(String space) {
      this.space = Objects.requireNonNull(space, "space");
      initBits &= ~INIT_BIT_SPACE;
      return this;
    }

    /**
     * Initializes the value for the {@link Route#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Builds a new {@link Route Route}.
     * @return An immutable instance of Route
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Route build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Route(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      if ((initBits & INIT_BIT_HOST) != 0) attributes.add("host");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_SPACE) != 0) attributes.add("space");
      return "Cannot build Route, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
