package org.cloudfoundry.operations.serviceadmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Request options for the update service broker operation
 */
@Generated(from = "_UpdateServiceBrokerRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateServiceBrokerRequest
    extends org.cloudfoundry.operations.serviceadmin._UpdateServiceBrokerRequest {
  private final String name;
  private final String password;
  private final String url;
  private final String username;

  private UpdateServiceBrokerRequest(UpdateServiceBrokerRequest.Builder builder) {
    this.name = builder.name;
    this.password = builder.password;
    this.url = builder.url;
    this.username = builder.username;
  }

  /**
   * The name of the service broker
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The password to authenticate with the broker
   */
  @Override
  public String getPassword() {
    return password;
  }

  /**
   * The url of the service broker
   */
  @Override
  public String getUrl() {
    return url;
  }

  /**
   * The username to authenticate with the broker
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code UpdateServiceBrokerRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateServiceBrokerRequest
        && equalTo(0, (UpdateServiceBrokerRequest) another);
  }

  private boolean equalTo(int synthetic, UpdateServiceBrokerRequest another) {
    return name.equals(another.name)
        && password.equals(another.password)
        && url.equals(another.url)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code password}, {@code url}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + password.hashCode();
    h += (h << 5) + url.hashCode();
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateServiceBrokerRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateServiceBrokerRequest{"
        + "name=" + name
        + ", password=" + password
        + ", url=" + url
        + ", username=" + username
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateServiceBrokerRequest UpdateServiceBrokerRequest}.
   * <pre>
   * UpdateServiceBrokerRequest.builder()
   *    .name(String) // required {@link UpdateServiceBrokerRequest#getName() name}
   *    .password(String) // required {@link UpdateServiceBrokerRequest#getPassword() password}
   *    .url(String) // required {@link UpdateServiceBrokerRequest#getUrl() url}
   *    .username(String) // required {@link UpdateServiceBrokerRequest#getUsername() username}
   *    .build();
   * </pre>
   * @return A new UpdateServiceBrokerRequest builder
   */
  public static UpdateServiceBrokerRequest.Builder builder() {
    return new UpdateServiceBrokerRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateServiceBrokerRequest UpdateServiceBrokerRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateServiceBrokerRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_PASSWORD = 0x2L;
    private static final long INIT_BIT_URL = 0x4L;
    private static final long INIT_BIT_USERNAME = 0x8L;
    private long initBits = 0xfL;

    private String name;
    private String password;
    private String url;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateServiceBrokerRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateServiceBrokerRequest instance) {
      return from((_UpdateServiceBrokerRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateServiceBrokerRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateServiceBrokerRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.getName());
      this.password(instance.getPassword());
      this.url(instance.getUrl());
      this.username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBrokerRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBrokerRequest#getPassword() password} attribute.
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      initBits &= ~INIT_BIT_PASSWORD;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBrokerRequest#getUrl() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder url(String url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateServiceBrokerRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link UpdateServiceBrokerRequest UpdateServiceBrokerRequest}.
     * @return An immutable instance of UpdateServiceBrokerRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateServiceBrokerRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateServiceBrokerRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_PASSWORD) != 0) attributes.add("password");
      if ((initBits & INIT_BIT_URL) != 0) attributes.add("url");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build UpdateServiceBrokerRequest, some of required attributes are not set " + attributes;
    }
  }
}
