package org.cloudfoundry.operations.services;

import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the marketplace operation
 */
@Generated(from = "_ListServiceOfferingsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListServiceOfferingsRequest
    extends org.cloudfoundry.operations.services._ListServiceOfferingsRequest {
  private final @Nullable String serviceName;

  private ListServiceOfferingsRequest(ListServiceOfferingsRequest.Builder builder) {
    this.serviceName = builder.serviceName;
  }

  /**
   * The name of the service
   */
  @Override
  public @Nullable String getServiceName() {
    return serviceName;
  }

  /**
   * This instance is equal to all instances of {@code ListServiceOfferingsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServiceOfferingsRequest
        && equalTo(0, (ListServiceOfferingsRequest) another);
  }

  private boolean equalTo(int synthetic, ListServiceOfferingsRequest another) {
    return Objects.equals(serviceName, another.serviceName);
  }

  /**
   * Computes a hash code from attributes: {@code serviceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(serviceName);
    return h;
  }

  /**
   * Prints the immutable value {@code ListServiceOfferingsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServiceOfferingsRequest{"
        + "serviceName=" + serviceName
        + "}";
  }

  /**
   * Creates a builder for {@link ListServiceOfferingsRequest ListServiceOfferingsRequest}.
   * <pre>
   * ListServiceOfferingsRequest.builder()
   *    .serviceName(String | null) // nullable {@link ListServiceOfferingsRequest#getServiceName() serviceName}
   *    .build();
   * </pre>
   * @return A new ListServiceOfferingsRequest builder
   */
  public static ListServiceOfferingsRequest.Builder builder() {
    return new ListServiceOfferingsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServiceOfferingsRequest ListServiceOfferingsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListServiceOfferingsRequest", generator = "Immutables")
  public static final class Builder {
    private String serviceName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServiceOfferingsRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServiceOfferingsRequest instance) {
      return from((_ListServiceOfferingsRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ListServiceOfferingsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListServiceOfferingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String serviceNameValue = instance.getServiceName();
      if (serviceNameValue != null) {
        serviceName(serviceNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListServiceOfferingsRequest#getServiceName() serviceName} attribute.
     * @param serviceName The value for serviceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceName(@Nullable String serviceName) {
      this.serviceName = serviceName;
      return this;
    }

    /**
     * Builds a new {@link ListServiceOfferingsRequest ListServiceOfferingsRequest}.
     * @return An immutable instance of ListServiceOfferingsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServiceOfferingsRequest build() {
      return new ListServiceOfferingsRequest(this);
    }
  }
}
