package org.cloudfoundry.operations.spaceadmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * A Cloud Foundry Space Quota
 */
@Generated(from = "_SpaceQuota", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class SpaceQuota extends org.cloudfoundry.operations.spaceadmin._SpaceQuota {
  private final String id;
  private final Integer instanceMemoryLimit;
  private final String name;
  private final String organizationId;
  private final Boolean paidServicePlans;
  private final Integer totalMemoryLimit;
  private final Integer totalRoutes;
  private final Integer totalServiceInstances;

  private SpaceQuota(SpaceQuota.Builder builder) {
    this.id = builder.id;
    this.instanceMemoryLimit = builder.instanceMemoryLimit;
    this.name = builder.name;
    this.organizationId = builder.organizationId;
    this.paidServicePlans = builder.paidServicePlans;
    this.totalMemoryLimit = builder.totalMemoryLimit;
    this.totalRoutes = builder.totalRoutes;
    this.totalServiceInstances = builder.totalServiceInstances;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The instance memory limit
   */
  @Override
  public Integer getInstanceMemoryLimit() {
    return instanceMemoryLimit;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * Whether paid service plans are allowed
   */
  @Override
  public Boolean getPaidServicePlans() {
    return paidServicePlans;
  }

  /**
   * The total memory limit
   */
  @Override
  public Integer getTotalMemoryLimit() {
    return totalMemoryLimit;
  }

  /**
   * The total number of routes
   */
  @Override
  public Integer getTotalRoutes() {
    return totalRoutes;
  }

  /**
   * The total number of service instances
   */
  @Override
  public Integer getTotalServiceInstances() {
    return totalServiceInstances;
  }

  /**
   * This instance is equal to all instances of {@code SpaceQuota} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SpaceQuota
        && equalTo(0, (SpaceQuota) another);
  }

  private boolean equalTo(int synthetic, SpaceQuota another) {
    return id.equals(another.id)
        && instanceMemoryLimit.equals(another.instanceMemoryLimit)
        && name.equals(another.name)
        && organizationId.equals(another.organizationId)
        && paidServicePlans.equals(another.paidServicePlans)
        && totalMemoryLimit.equals(another.totalMemoryLimit)
        && totalRoutes.equals(another.totalRoutes)
        && totalServiceInstances.equals(another.totalServiceInstances);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code instanceMemoryLimit}, {@code name}, {@code organizationId}, {@code paidServicePlans}, {@code totalMemoryLimit}, {@code totalRoutes}, {@code totalServiceInstances}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + instanceMemoryLimit.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + paidServicePlans.hashCode();
    h += (h << 5) + totalMemoryLimit.hashCode();
    h += (h << 5) + totalRoutes.hashCode();
    h += (h << 5) + totalServiceInstances.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SpaceQuota} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SpaceQuota{"
        + "id=" + id
        + ", instanceMemoryLimit=" + instanceMemoryLimit
        + ", name=" + name
        + ", organizationId=" + organizationId
        + ", paidServicePlans=" + paidServicePlans
        + ", totalMemoryLimit=" + totalMemoryLimit
        + ", totalRoutes=" + totalRoutes
        + ", totalServiceInstances=" + totalServiceInstances
        + "}";
  }

  /**
   * Creates a builder for {@link SpaceQuota SpaceQuota}.
   * <pre>
   * SpaceQuota.builder()
   *    .id(String) // required {@link SpaceQuota#getId() id}
   *    .instanceMemoryLimit(Integer) // required {@link SpaceQuota#getInstanceMemoryLimit() instanceMemoryLimit}
   *    .name(String) // required {@link SpaceQuota#getName() name}
   *    .organizationId(String) // required {@link SpaceQuota#getOrganizationId() organizationId}
   *    .paidServicePlans(Boolean) // required {@link SpaceQuota#getPaidServicePlans() paidServicePlans}
   *    .totalMemoryLimit(Integer) // required {@link SpaceQuota#getTotalMemoryLimit() totalMemoryLimit}
   *    .totalRoutes(Integer) // required {@link SpaceQuota#getTotalRoutes() totalRoutes}
   *    .totalServiceInstances(Integer) // required {@link SpaceQuota#getTotalServiceInstances() totalServiceInstances}
   *    .build();
   * </pre>
   * @return A new SpaceQuota builder
   */
  public static SpaceQuota.Builder builder() {
    return new SpaceQuota.Builder();
  }

  /**
   * Builds instances of type {@link SpaceQuota SpaceQuota}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_SpaceQuota", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_INSTANCE_MEMORY_LIMIT = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_ORGANIZATION_ID = 0x8L;
    private static final long INIT_BIT_PAID_SERVICE_PLANS = 0x10L;
    private static final long INIT_BIT_TOTAL_MEMORY_LIMIT = 0x20L;
    private static final long INIT_BIT_TOTAL_ROUTES = 0x40L;
    private static final long INIT_BIT_TOTAL_SERVICE_INSTANCES = 0x80L;
    private long initBits = 0xffL;

    private String id;
    private Integer instanceMemoryLimit;
    private String name;
    private String organizationId;
    private Boolean paidServicePlans;
    private Integer totalMemoryLimit;
    private Integer totalRoutes;
    private Integer totalServiceInstances;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SpaceQuota} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SpaceQuota instance) {
      return from((_SpaceQuota) instance);
    }

    /**
     * Copy abstract value type {@code _SpaceQuota} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SpaceQuota instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      this.instanceMemoryLimit(instance.getInstanceMemoryLimit());
      this.name(instance.getName());
      this.organizationId(instance.getOrganizationId());
      this.paidServicePlans(instance.getPaidServicePlans());
      this.totalMemoryLimit(instance.getTotalMemoryLimit());
      this.totalRoutes(instance.getTotalRoutes());
      this.totalServiceInstances(instance.getTotalServiceInstances());
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceQuota#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceQuota#getInstanceMemoryLimit() instanceMemoryLimit} attribute.
     * @param instanceMemoryLimit The value for instanceMemoryLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceMemoryLimit(Integer instanceMemoryLimit) {
      this.instanceMemoryLimit = Objects.requireNonNull(instanceMemoryLimit, "instanceMemoryLimit");
      initBits &= ~INIT_BIT_INSTANCE_MEMORY_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceQuota#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceQuota#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceQuota#getPaidServicePlans() paidServicePlans} attribute.
     * @param paidServicePlans The value for paidServicePlans 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder paidServicePlans(Boolean paidServicePlans) {
      this.paidServicePlans = Objects.requireNonNull(paidServicePlans, "paidServicePlans");
      initBits &= ~INIT_BIT_PAID_SERVICE_PLANS;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceQuota#getTotalMemoryLimit() totalMemoryLimit} attribute.
     * @param totalMemoryLimit The value for totalMemoryLimit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalMemoryLimit(Integer totalMemoryLimit) {
      this.totalMemoryLimit = Objects.requireNonNull(totalMemoryLimit, "totalMemoryLimit");
      initBits &= ~INIT_BIT_TOTAL_MEMORY_LIMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceQuota#getTotalRoutes() totalRoutes} attribute.
     * @param totalRoutes The value for totalRoutes 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalRoutes(Integer totalRoutes) {
      this.totalRoutes = Objects.requireNonNull(totalRoutes, "totalRoutes");
      initBits &= ~INIT_BIT_TOTAL_ROUTES;
      return this;
    }

    /**
     * Initializes the value for the {@link SpaceQuota#getTotalServiceInstances() totalServiceInstances} attribute.
     * @param totalServiceInstances The value for totalServiceInstances 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalServiceInstances(Integer totalServiceInstances) {
      this.totalServiceInstances = Objects.requireNonNull(totalServiceInstances, "totalServiceInstances");
      initBits &= ~INIT_BIT_TOTAL_SERVICE_INSTANCES;
      return this;
    }

    /**
     * Builds a new {@link SpaceQuota SpaceQuota}.
     * @return An immutable instance of SpaceQuota
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SpaceQuota build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SpaceQuota(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_INSTANCE_MEMORY_LIMIT) != 0) attributes.add("instanceMemoryLimit");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      if ((initBits & INIT_BIT_PAID_SERVICE_PLANS) != 0) attributes.add("paidServicePlans");
      if ((initBits & INIT_BIT_TOTAL_MEMORY_LIMIT) != 0) attributes.add("totalMemoryLimit");
      if ((initBits & INIT_BIT_TOTAL_ROUTES) != 0) attributes.add("totalRoutes");
      if ((initBits & INIT_BIT_TOTAL_SERVICE_INSTANCES) != 0) attributes.add("totalServiceInstances");
      return "Cannot build SpaceQuota, some of required attributes are not set " + attributes;
    }
  }
}
