/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.operations.serviceadmin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.operations.serviceadmin.Access;
import org.cloudfoundry.operations.serviceadmin._ServiceAccess;
import org.immutables.value.Generated;

@Generated(from="_ServiceAccess", generator="Immutables")
public final class ServiceAccess
extends _ServiceAccess {
    private final Access access;
    private final String brokerName;
    @Nullable
    private final List<String> organizationNames;
    private final String planName;
    private final String serviceName;

    private ServiceAccess(Builder builder) {
        this.access = builder.access;
        this.brokerName = builder.brokerName;
        this.organizationNames = builder.organizationNames == null ? null : ServiceAccess.createUnmodifiableList(true, builder.organizationNames);
        this.planName = builder.planName;
        this.serviceName = builder.serviceName;
    }

    @Override
    public Access getAccess() {
        return this.access;
    }

    @Override
    public String getBrokerName() {
        return this.brokerName;
    }

    @Override
    @Nullable
    public List<String> getOrganizationNames() {
        return this.organizationNames;
    }

    @Override
    public String getPlanName() {
        return this.planName;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceAccess && this.equalTo((ServiceAccess)another);
    }

    private boolean equalTo(ServiceAccess another) {
        return this.access.equals((Object)another.access) && this.brokerName.equals(another.brokerName) && Objects.equals(this.organizationNames, another.organizationNames) && this.planName.equals(another.planName) && this.serviceName.equals(another.serviceName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.access.hashCode();
        h += (h << 5) + this.brokerName.hashCode();
        h += (h << 5) + Objects.hashCode(this.organizationNames);
        h += (h << 5) + this.planName.hashCode();
        h += (h << 5) + this.serviceName.hashCode();
        return h;
    }

    public String toString() {
        return "ServiceAccess{access=" + (Object)((Object)this.access) + ", brokerName=" + this.brokerName + ", organizationNames=" + this.organizationNames + ", planName=" + this.planName + ", serviceName=" + this.serviceName + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ServiceAccess", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ACCESS = 1L;
        private static final long INIT_BIT_BROKER_NAME = 2L;
        private static final long INIT_BIT_PLAN_NAME = 4L;
        private static final long INIT_BIT_SERVICE_NAME = 8L;
        private long initBits = 15L;
        private Access access;
        private String brokerName;
        private List<String> organizationNames = null;
        private String planName;
        private String serviceName;

        private Builder() {
        }

        public final Builder from(ServiceAccess instance) {
            return this.from((_ServiceAccess)instance);
        }

        final Builder from(_ServiceAccess instance) {
            Objects.requireNonNull(instance, "instance");
            this.access(instance.getAccess());
            this.brokerName(instance.getBrokerName());
            List<String> organizationNamesValue = instance.getOrganizationNames();
            if (organizationNamesValue != null) {
                this.addAllOrganizationNames(organizationNamesValue);
            }
            this.planName(instance.getPlanName());
            this.serviceName(instance.getServiceName());
            return this;
        }

        public final Builder access(Access access) {
            this.access = Objects.requireNonNull(access, "access");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder brokerName(String brokerName) {
            this.brokerName = Objects.requireNonNull(brokerName, "brokerName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder organizationName(String element) {
            if (this.organizationNames == null) {
                this.organizationNames = new ArrayList<String>();
            }
            this.organizationNames.add(Objects.requireNonNull(element, "organizationNames element"));
            return this;
        }

        public final Builder organizationNames(String ... elements) {
            if (this.organizationNames == null) {
                this.organizationNames = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationNames.add(Objects.requireNonNull(element, "organizationNames element"));
            }
            return this;
        }

        public final Builder organizationNames(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.organizationNames = null;
                return this;
            }
            this.organizationNames = new ArrayList<String>();
            return this.addAllOrganizationNames(elements);
        }

        public final Builder addAllOrganizationNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "organizationNames element");
            if (this.organizationNames == null) {
                this.organizationNames = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationNames.add(Objects.requireNonNull(element, "organizationNames element"));
            }
            return this;
        }

        public final Builder planName(String planName) {
            this.planName = Objects.requireNonNull(planName, "planName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder serviceName(String serviceName) {
            this.serviceName = Objects.requireNonNull(serviceName, "serviceName");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ServiceAccess build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ServiceAccess(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("access");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("brokerName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("planName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("serviceName");
            }
            return "Cannot build ServiceAccess, some of required attributes are not set " + attributes;
        }
    }
}

