/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@JsonDeserialize(using=UserInfoResponsDeserializer.class)
@JsonSerialize(using=UserInfoResponseSerializer.class)
public class UserInfoResponse {
    private static final MultiValueMap<String, Object> EMPTY_MAP = new LinkedMultiValueMap();
    MultiValueMap<String, Object> attributes = new LinkedMultiValueMap();

    public String getUserId() {
        return (String)this.getAttributeValue("user_id");
    }

    public void setUserId(String userId) {
        this.setAttributeValue("user_id", userId);
    }

    public String getUsername() {
        return (String)this.getAttributeValue("user_name");
    }

    public void setUsername(String username) {
        this.setAttributeValue("user_name", username);
    }

    public String getGivenName() {
        return (String)this.getAttributeValue("given_name");
    }

    public void setGivenName(String givenName) {
        this.setAttributeValue("given_name", givenName);
    }

    public String getFamilyName() {
        return (String)this.getAttributeValue("family_name");
    }

    public void setFamilyName(String familyName) {
        this.setAttributeValue("family_name", familyName);
    }

    @JsonProperty(value="name")
    public String getFullName() {
        return (this.getGivenName() != null ? this.getGivenName() : "") + (this.getFamilyName() != null ? " " + this.getFamilyName() : "");
    }

    public String getEmail() {
        return (String)this.getAttributeValue("email");
    }

    public void setEmail(String email) {
        this.setAttributeValue("email", email);
    }

    public String getPhoneNumber() {
        return (String)this.getAttributeValue("phone_number");
    }

    public void setPhoneNumber(String phoneNumber) {
        this.setAttributeValue("phone_number", phoneNumber);
    }

    public String getSub() {
        return this.getUserId();
    }

    public void setSub(String sub) {
        this.setUserId(sub);
    }

    public MultiValueMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributeValue(String name, Object value) {
        this.setAttributeValues(name, Arrays.asList(value));
    }

    public void setAttributeValues(String name, List<Object> value) {
        this.attributes.put((Object)name, value);
    }

    public List<Object> getAttributeValues(String name) {
        return (List)this.attributes.get((Object)name);
    }

    public Object getAttributeValue(String name) {
        return this.attributes.getFirst((Object)name);
    }

    public void addAttributes(MultiValueMap<String, Object> attr) {
        Optional.ofNullable(attr).orElse(EMPTY_MAP).entrySet().stream().forEach(e -> this.setAttributeValues((String)e.getKey(), (List)e.getValue()));
    }

    public Long getPreviousLogonSuccess() {
        return (Long)this.getAttributeValue("previous_logon_time");
    }

    public void setPreviousLogonSuccess(Long previousLogonSuccess) {
        this.setAttributeValue("previous_logon_time", previousLogonSuccess);
    }

    public static class UserInfoResponsDeserializer
    extends JsonDeserializer<UserInfoResponse> {
        public UserInfoResponse deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = JsonUtils.readTree((JsonParser)p);
            Map map = JsonUtils.getNodeAsMap((JsonNode)node);
            UserInfoResponse response = new UserInfoResponse();
            block16: for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                switch (key) {
                    case "name": {
                        continue block16;
                    }
                    case "sub": {
                        key = "user_id";
                    }
                    case "user_name": 
                    case "given_name": 
                    case "family_name": 
                    case "phone_number": 
                    case "email": {
                        response.setAttributeValue(key, value);
                        continue block16;
                    }
                    case "previous_logon_time": {
                        if (value == null) continue block16;
                        Long longValue = value.getClass() == Long.class ? (Long)value : Long.valueOf(((Integer)value).longValue());
                        response.setAttributeValue(key, longValue);
                        continue block16;
                    }
                }
                if (value instanceof List) {
                    response.setAttributeValues(key, (List)value);
                    continue;
                }
                response.setAttributeValue(key, value);
            }
            return response;
        }
    }

    public static class UserInfoResponseSerializer
    extends JsonSerializer<UserInfoResponse> {
        public void serialize(UserInfoResponse object, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            block16: for (Map.Entry entry : object.getAttributes().entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                switch (key) {
                    case "user_id": {
                        gen.writeFieldName("user_id");
                        gen.writeObject((Object)object.getUserId());
                        key = "sub";
                    }
                    case "user_name": 
                    case "given_name": 
                    case "family_name": 
                    case "phone_number": 
                    case "user_attributes": 
                    case "roles": 
                    case "email": {
                        gen.writeFieldName(key);
                        if (value == null || value.size() == 0) {
                            gen.writeNull();
                            continue block16;
                        }
                        gen.writeObject(value.get(0));
                        continue block16;
                    }
                    case "previous_logon_time": {
                        gen.writeFieldName(key);
                        gen.writeObject(value.get(0));
                        continue block16;
                    }
                }
                gen.writeFieldName(key);
                gen.writeObject((Object)value);
            }
            gen.writeFieldName("name");
            gen.writeObject((Object)object.getFullName());
            gen.writeEndObject();
        }
    }
}

