/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.approval;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Calendar;
import java.util.Date;
import org.cloudfoundry.identity.uaa.approval.impl.ApprovalsJsonDeserializer;
import org.cloudfoundry.identity.uaa.impl.JsonDateDeserializer;
import org.cloudfoundry.identity.uaa.impl.JsonDateSerializer;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(using=ApprovalsJsonDeserializer.class)
public class Approval {
    private String userId = "";
    private String clientId = "";
    private String scope = "";
    private ApprovalStatus status;
    private Date expiresAt;
    private Date lastUpdatedAt = new Date();

    public static Date timeFromNow(int timeTill) {
        Calendar timeOf = Calendar.getInstance();
        timeOf.add(14, timeTill);
        return timeOf.getTime();
    }

    public String getUserId() {
        return this.userId;
    }

    public Approval setUserId(String userId) {
        this.userId = userId == null ? "" : userId;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Approval setClientId(String clientId) {
        this.clientId = clientId == null ? "" : clientId;
        return this;
    }

    public ApprovalStatus getStatus() {
        return this.status;
    }

    public String getScope() {
        return this.scope;
    }

    public Approval setScope(String scope) {
        this.scope = scope == null ? "" : scope;
        return this;
    }

    @JsonSerialize(using=JsonDateSerializer.class)
    @JsonProperty(value="expiresAt")
    public Date getExpiresAt() {
        if (this.expiresAt == null) {
            Calendar thirtyMinFromNow = Calendar.getInstance();
            thirtyMinFromNow.add(12, 30);
            this.expiresAt = thirtyMinFromNow.getTime();
        }
        return this.expiresAt;
    }

    @JsonDeserialize(using=JsonDateDeserializer.class)
    @JsonProperty(value="expiresAt")
    public Approval setExpiresAt(Date expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @JsonSerialize(using=JsonDateSerializer.class)
    public Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    @JsonDeserialize(using=JsonDateDeserializer.class)
    public Approval setLastUpdatedAt(Date lastUpdatedAt) {
        if (lastUpdatedAt == null) {
            throw new IllegalArgumentException("lastUpdatedAt cannot be null");
        }
        this.lastUpdatedAt = lastUpdatedAt;
        return this;
    }

    @JsonIgnore
    public boolean isCurrentlyActive() {
        return this.expiresAt != null && this.expiresAt.after(new Date());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.userId.hashCode();
        result = 31 * result + this.clientId.hashCode();
        result = 31 * result + this.scope.hashCode();
        result = 31 * result + this.status.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Approval)) {
            return false;
        }
        Approval other = (Approval)o;
        return this.userId.equals(other.userId) && this.clientId.equals(other.clientId) && this.scope.equals(other.scope) && this.status == other.status;
    }

    public String toString() {
        return String.format("[%s, %s, %s, %s, %s, %s]", this.userId, this.scope, this.clientId, this.expiresAt, this.status.toString(), this.lastUpdatedAt);
    }

    public Approval setStatus(ApprovalStatus status) {
        this.status = status;
        return this;
    }

    public static enum ApprovalStatus {
        APPROVED,
        DENIED;

    }
}

