/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.codestore;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.sql.Timestamp;

@JsonSerialize
@JsonDeserialize
public class ExpiringCode {
    private String code;
    private Timestamp expiresAt;
    private String data;
    private String intent;

    public ExpiringCode() {
    }

    public ExpiringCode(String code, Timestamp expiresAt, String data, String intent) {
        this.code = code;
        this.expiresAt = expiresAt;
        this.data = data;
        this.intent = intent;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Timestamp getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(Timestamp expiresAt) {
        this.expiresAt = expiresAt;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getIntent() {
        return this.intent;
    }

    public void setIntent(String intent) {
        this.intent = intent;
    }

    @JsonIgnore
    public boolean isExpired() {
        if (this.expiresAt == null) {
            return false;
        }
        return this.expiresAt.getTime() < System.currentTimeMillis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpiringCode)) {
            return false;
        }
        ExpiringCode that = (ExpiringCode)o;
        if (this.code != null ? !this.code.equals(that.code) : that.code != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        return !(this.expiresAt != null ? !this.expiresAt.equals(that.expiresAt) : that.expiresAt != null);
    }

    public int hashCode() {
        return this.code != null ? this.code.hashCode() : 0;
    }

    public String toString() {
        return "ExpiringCode [code=" + this.code + ", expiresAt=" + this.expiresAt + ", data=" + this.trimToLength(this.data, 1024) + ", intent=" + this.intent + "]";
    }

    private String trimToLength(String s, int length) {
        int min = Math.min(s.length(), length);
        if (min == s.length()) {
            return s;
        }
        return s.substring(0, min);
    }
}

