/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.mfa_provider;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cloudfoundry.identity.uaa.mfa_provider.AbstractMfaProviderConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GoogleMfaProviderConfig
extends AbstractMfaProviderConfig<GoogleMfaProviderConfig> {
    private String providerDescription;
    private int digits = 6;
    private int duration = 30;
    private Algorithm algorithm = Algorithm.SHA256;

    @Override
    public void validate() {
    }

    public String getProviderDescription() {
        return this.providerDescription;
    }

    public GoogleMfaProviderConfig setProviderDescription(String providerDescription) {
        this.providerDescription = providerDescription;
        return this;
    }

    public int getDigits() {
        return this.digits;
    }

    public GoogleMfaProviderConfig setDigits(int digits) {
        this.digits = digits;
        return this;
    }

    public int getDuration() {
        return this.duration;
    }

    public GoogleMfaProviderConfig setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public GoogleMfaProviderConfig setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoogleMfaProviderConfig that = (GoogleMfaProviderConfig)o;
        if (this.digits != that.digits) {
            return false;
        }
        if (this.duration != that.duration) {
            return false;
        }
        if (this.providerDescription != null ? !this.providerDescription.equals(that.providerDescription) : that.providerDescription != null) {
            return false;
        }
        if (this.algorithm != that.algorithm) {
            return false;
        }
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result += this.providerDescription != null ? this.providerDescription.hashCode() : 0;
        result = 31 * result + this.digits;
        result = 31 * result + this.duration;
        result = 31 * result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
        return result;
    }

    public static enum Algorithm {
        SHA256,
        SHA512;

        private static Map<String, Algorithm> namesMap;

        @JsonCreator
        public static Algorithm forValue(String value) {
            return namesMap.get(value);
        }

        public static Set<String> getStringaValues() {
            return namesMap.keySet();
        }

        static {
            namesMap = new HashMap<String, Algorithm>();
            namesMap.put("SHA256", SHA256);
            namesMap.put("SHA512", SHA512);
        }
    }
}

