/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.token;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.cloudfoundry.identity.uaa.oauth.token.CompositeAccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.util.Assert;

public final class CompositeAccessTokenSerializer
extends StdSerializer<CompositeAccessToken> {
    public CompositeAccessTokenSerializer() {
        super(CompositeAccessToken.class);
    }

    public void serialize(CompositeAccessToken token, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        Set scope;
        Date expiration;
        OAuth2RefreshToken refreshToken;
        jgen.writeStartObject();
        jgen.writeStringField("access_token", token.getValue());
        jgen.writeStringField("token_type", token.getTokenType());
        if (token instanceof CompositeAccessToken && token.getIdTokenValue() != null) {
            jgen.writeStringField(CompositeAccessToken.ID_TOKEN, token.getIdTokenValue());
        }
        if ((refreshToken = token.getRefreshToken()) != null) {
            jgen.writeStringField("refresh_token", refreshToken.getValue());
        }
        if ((expiration = token.getExpiration()) != null) {
            long now = System.currentTimeMillis();
            jgen.writeNumberField("expires_in", (expiration.getTime() - now) / 1000L);
        }
        if ((scope = token.getScope()) != null && !scope.isEmpty()) {
            StringBuffer scopes = new StringBuffer();
            for (String s : scope) {
                Assert.hasLength((String)s, (String)("Scopes cannot be null or empty. Got " + scope + ""));
                scopes.append(s);
                scopes.append(" ");
            }
            jgen.writeStringField("scope", scopes.substring(0, scopes.length() - 1));
        }
        Map additionalInformation = token.getAdditionalInformation();
        for (String key : additionalInformation.keySet()) {
            jgen.writeObjectField(key, additionalInformation.get(key));
        }
        jgen.writeEndObject();
    }
}

