/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider;

public class LockoutPolicy {
    private int lockoutPeriodSeconds;
    private int lockoutAfterFailures;
    private int countFailuresWithin;

    public LockoutPolicy() {
        this.countFailuresWithin = -1;
        this.lockoutAfterFailures = -1;
        this.lockoutPeriodSeconds = -1;
    }

    public LockoutPolicy(int countFailuresWithin, int lockoutAfterFailures, int lockoutPeriodSeconds) {
        this.countFailuresWithin = countFailuresWithin;
        this.lockoutAfterFailures = lockoutAfterFailures;
        this.lockoutPeriodSeconds = lockoutPeriodSeconds;
    }

    public LockoutPolicy setLockoutPeriodSeconds(int lockoutPeriod) {
        this.lockoutPeriodSeconds = lockoutPeriod;
        return this;
    }

    public LockoutPolicy setLockoutAfterFailures(int allowedFailures) {
        this.lockoutAfterFailures = allowedFailures;
        return this;
    }

    public LockoutPolicy setCountFailuresWithin(int interval) {
        this.countFailuresWithin = interval;
        return this;
    }

    public int getLockoutPeriodSeconds() {
        return this.lockoutPeriodSeconds;
    }

    public int getLockoutAfterFailures() {
        return this.lockoutAfterFailures;
    }

    public int getCountFailuresWithin() {
        return this.countFailuresWithin;
    }

    public boolean allPresentAndPositive() {
        return this.lockoutPeriodSeconds >= 0 && this.lockoutAfterFailures >= 0 && this.countFailuresWithin >= 0;
    }
}

