/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.cloudfoundry.identity.uaa.provider.ExternalIdentityProviderDefinition;
import org.springframework.util.StringUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SamlIdentityProviderDefinition
extends ExternalIdentityProviderDefinition {
    private String metaDataLocation;
    private String idpEntityAlias;
    private String zoneId;
    private String nameID;
    private int assertionConsumerIndex;
    private boolean metadataTrustCheck;
    private boolean showSamlLink;
    private String linkText;
    private String iconUrl;
    private ExternalGroupMappingMode groupMappingMode = ExternalGroupMappingMode.EXPLICITLY_MAPPED;
    private boolean skipSslValidation = false;
    private List<String> authnContext;

    public SamlIdentityProviderDefinition clone() {
        ArrayList<String> emailDomain = this.getEmailDomain() != null ? new ArrayList<String>(this.getEmailDomain()) : null;
        ArrayList<String> externalGroupsWhitelist = this.getExternalGroupsWhitelist() != null ? new ArrayList<String>(this.getExternalGroupsWhitelist()) : null;
        ArrayList<String> authnContext = this.getAuthnContext() != null ? new ArrayList<String>(this.getAuthnContext()) : null;
        HashMap<String, Object> attributeMappings = this.getAttributeMappings() != null ? new HashMap<String, Object>(this.getAttributeMappings()) : null;
        SamlIdentityProviderDefinition def = new SamlIdentityProviderDefinition();
        def.setMetaDataLocation(this.metaDataLocation);
        def.setIdpEntityAlias(this.idpEntityAlias);
        def.setZoneId(this.zoneId);
        def.setNameID(this.nameID);
        def.setAssertionConsumerIndex(this.assertionConsumerIndex);
        def.setMetadataTrustCheck(this.metadataTrustCheck);
        def.setShowSamlLink(this.showSamlLink);
        def.setLinkText(this.linkText);
        def.setIconUrl(this.iconUrl);
        def.setAddShadowUserOnLogin(this.isAddShadowUserOnLogin());
        def.setEmailDomain(emailDomain);
        def.setExternalGroupsWhitelist(externalGroupsWhitelist);
        def.setAttributeMappings(attributeMappings);
        def.setAdditionalConfiguration(this.getAdditionalConfiguration());
        def.setProviderDescription(this.getProviderDescription());
        def.setGroupMappingMode(this.getGroupMappingMode());
        def.setSocketFactoryClassName(this.getSocketFactoryClassName());
        def.setSkipSslValidation(this.isSkipSslValidation());
        def.setStoreCustomAttributes(this.isStoreCustomAttributes());
        def.setAuthnContext(authnContext);
        return def;
    }

    @JsonIgnore
    public MetadataLocation getType() {
        String trimmedLocation = this.metaDataLocation.trim();
        if (trimmedLocation.startsWith("<?xml") || trimmedLocation.startsWith("<md:EntityDescriptor") || trimmedLocation.startsWith("<EntityDescriptor")) {
            if (this.validateXml(trimmedLocation)) {
                return MetadataLocation.DATA;
            }
        } else if (trimmedLocation.startsWith("http")) {
            try {
                URL uri = new URL(trimmedLocation);
                return MetadataLocation.URL;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return MetadataLocation.UNKNOWN;
    }

    private boolean validateXml(String xml) {
        if (xml == null || xml.toUpperCase().contains("<!DOCTYPE")) {
            return false;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return false;
        }
        return true;
    }

    public String getMetaDataLocation() {
        return this.metaDataLocation;
    }

    public SamlIdentityProviderDefinition setMetaDataLocation(String metaDataLocation) {
        this.metaDataLocation = metaDataLocation;
        return this;
    }

    public String getIdpEntityAlias() {
        return this.idpEntityAlias;
    }

    public SamlIdentityProviderDefinition setIdpEntityAlias(String idpEntityAlias) {
        this.idpEntityAlias = idpEntityAlias;
        return this;
    }

    public String getNameID() {
        return this.nameID;
    }

    public SamlIdentityProviderDefinition setNameID(String nameID) {
        this.nameID = nameID;
        return this;
    }

    public List<String> getAuthnContext() {
        return this.authnContext;
    }

    public SamlIdentityProviderDefinition setAuthnContext(List<String> authnContext) {
        this.authnContext = authnContext;
        return this;
    }

    public int getAssertionConsumerIndex() {
        return this.assertionConsumerIndex;
    }

    public SamlIdentityProviderDefinition setAssertionConsumerIndex(int assertionConsumerIndex) {
        this.assertionConsumerIndex = assertionConsumerIndex;
        return this;
    }

    public boolean isMetadataTrustCheck() {
        return this.metadataTrustCheck;
    }

    public SamlIdentityProviderDefinition setMetadataTrustCheck(boolean metadataTrustCheck) {
        this.metadataTrustCheck = metadataTrustCheck;
        return this;
    }

    public boolean isShowSamlLink() {
        return this.showSamlLink;
    }

    public SamlIdentityProviderDefinition setShowSamlLink(boolean showSamlLink) {
        this.showSamlLink = showSamlLink;
        return this;
    }

    public ExternalGroupMappingMode getGroupMappingMode() {
        return this.groupMappingMode;
    }

    public void setGroupMappingMode(ExternalGroupMappingMode asScopes) {
        this.groupMappingMode = asScopes;
    }

    public String getSocketFactoryClassName() {
        return null;
    }

    public SamlIdentityProviderDefinition setSocketFactoryClassName(String socketFactoryClassName) {
        return this;
    }

    public String getLinkText() {
        return StringUtils.hasText((String)this.linkText) ? this.linkText : this.idpEntityAlias;
    }

    public SamlIdentityProviderDefinition setLinkText(String linkText) {
        this.linkText = linkText;
        return this;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public SamlIdentityProviderDefinition setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public SamlIdentityProviderDefinition setZoneId(String zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    public boolean isSkipSslValidation() {
        return this.skipSslValidation;
    }

    public void setSkipSslValidation(boolean skipSslValidation) {
        this.skipSslValidation = skipSslValidation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SamlIdentityProviderDefinition that = (SamlIdentityProviderDefinition)o;
        return Objects.equals(this.getUniqueAlias(), that.getUniqueAlias());
    }

    @Override
    public int hashCode() {
        String alias = this.getUniqueAlias();
        return alias == null ? 0 : alias.hashCode();
    }

    @JsonIgnore
    public String getUniqueAlias() {
        return this.getIdpEntityAlias() + "###" + this.getZoneId();
    }

    public String toString() {
        return "SamlIdentityProviderDefinition{idpEntityAlias='" + this.idpEntityAlias + '\'' + ", metaDataLocation='" + this.metaDataLocation + '\'' + ", nameID='" + this.nameID + '\'' + ", assertionConsumerIndex=" + this.assertionConsumerIndex + ", metadataTrustCheck=" + this.metadataTrustCheck + ", showSamlLink=" + this.showSamlLink + ", socketFactoryClassName='deprected-not used', skipSslValidation=" + this.skipSslValidation + ", linkText='" + this.linkText + '\'' + ", iconUrl='" + this.iconUrl + '\'' + ", zoneId='" + this.zoneId + '\'' + ", addShadowUserOnLogin='" + this.isAddShadowUserOnLogin() + '\'' + '}';
    }

    public static enum ExternalGroupMappingMode {
        EXPLICITLY_MAPPED,
        AS_SCOPES;

    }

    public static enum MetadataLocation {
        URL,
        DATA,
        UNKNOWN;

    }
}

