/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml.idp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Date;
import javax.validation.constraints.NotNull;
import org.cloudfoundry.identity.uaa.provider.saml.idp.SamlServiceProviderDefinition;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.util.StringUtils;

@JsonSerialize(using=SamlServiceProviderSerializer.class)
@JsonDeserialize(using=SamlServiceProviderDeserializer.class)
public class SamlServiceProvider {
    public static final String FIELD_ID = "id";
    public static final String FIELD_ENTITY_ID = "entityId";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_VERSION = "version";
    public static final String FIELD_CREATED = "created";
    public static final String FIELD_LAST_MODIFIED = "lastModified";
    public static final String FIELD_ACTIVE = "active";
    public static final String FIELD_IDENTITY_ZONE_ID = "identityZoneId";
    public static final String FIELD_CONFIG = "config";
    private String id;
    @NotNull
    private String entityId;
    @NotNull
    private String name;
    private SamlServiceProviderDefinition config;
    private int version = 0;
    private Date created = new Date();
    private Date lastModified = new Date();
    private boolean active = true;
    private String identityZoneId;

    public Date getCreated() {
        return this.created;
    }

    public SamlServiceProvider setCreated(Date created) {
        this.created = created;
        return this;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public SamlServiceProvider setLastModified(Date lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public SamlServiceProvider setVersion(int version) {
        this.version = version;
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public SamlServiceProvider setName(String name) {
        this.name = name;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public SamlServiceProvider setId(String id) {
        this.id = id;
        return this;
    }

    public SamlServiceProviderDefinition getConfig() {
        return this.config;
    }

    public SamlServiceProvider setConfig(SamlServiceProviderDefinition config) {
        this.config = config;
        return this;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public SamlServiceProvider setEntityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    public boolean isActive() {
        return this.active;
    }

    public SamlServiceProvider setActive(boolean active) {
        this.active = active;
        return this;
    }

    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    public SamlServiceProvider setIdentityZoneId(String identityZoneId) {
        this.identityZoneId = identityZoneId;
        return this;
    }

    public boolean configIsValid() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.created == null ? 0 : this.created.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.entityId == null ? 0 : this.entityId.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SamlServiceProvider other = (SamlServiceProvider)obj;
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        if (this.created == null ? other.created != null : !this.created.equals(other.created)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.entityId == null ? other.entityId != null : !this.entityId.equals(other.entityId)) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SamlServiceProvider{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", entityId='").append(this.entityId).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", active=").append(this.active);
        sb.append('}');
        return sb.toString();
    }

    public static class SamlServiceProviderDeserializer
    extends JsonDeserializer<SamlServiceProvider> {
        public SamlServiceProvider deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            SamlServiceProvider result = new SamlServiceProvider();
            JsonNode node = JsonUtils.readTree((JsonParser)jp);
            String config = this.getNodeAsString(node, SamlServiceProvider.FIELD_CONFIG, null);
            SamlServiceProviderDefinition definition = null;
            if (StringUtils.hasText((String)config)) {
                definition = (SamlServiceProviderDefinition)JsonUtils.readValue((String)config, SamlServiceProviderDefinition.class);
            }
            result.setConfig(definition);
            result.setId(this.getNodeAsString(node, SamlServiceProvider.FIELD_ID, null));
            result.setEntityId(this.getNodeAsString(node, SamlServiceProvider.FIELD_ENTITY_ID, null));
            result.setName(this.getNodeAsString(node, SamlServiceProvider.FIELD_NAME, null));
            result.setVersion(this.getNodeAsInt(node, SamlServiceProvider.FIELD_VERSION, 0));
            result.setCreated(this.getNodeAsDate(node, SamlServiceProvider.FIELD_CREATED));
            result.setLastModified(this.getNodeAsDate(node, SamlServiceProvider.FIELD_LAST_MODIFIED));
            result.setActive(this.getNodeAsBoolean(node, SamlServiceProvider.FIELD_ACTIVE, true));
            result.setIdentityZoneId(this.getNodeAsString(node, SamlServiceProvider.FIELD_IDENTITY_ZONE_ID, null));
            return result;
        }

        protected String getNodeAsString(JsonNode node, String fieldName, String defaultValue) {
            JsonNode typeNode = node.get(fieldName);
            return typeNode == null ? defaultValue : typeNode.asText(defaultValue);
        }

        protected int getNodeAsInt(JsonNode node, String fieldName, int defaultValue) {
            JsonNode typeNode = node.get(fieldName);
            return typeNode == null ? defaultValue : typeNode.asInt(defaultValue);
        }

        protected boolean getNodeAsBoolean(JsonNode node, String fieldName, boolean defaultValue) {
            JsonNode typeNode = node.get(fieldName);
            return typeNode == null ? defaultValue : typeNode.asBoolean(defaultValue);
        }

        protected Date getNodeAsDate(JsonNode node, String fieldName) {
            long date;
            JsonNode typeNode = node.get(fieldName);
            long l = date = typeNode == null ? -1L : typeNode.asLong(-1L);
            if (date == -1L) {
                return null;
            }
            return new Date(date);
        }
    }

    public static class SamlServiceProviderSerializer
    extends JsonSerializer<SamlServiceProvider> {
        public void serialize(SamlServiceProvider value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeStartObject();
            gen.writeStringField(SamlServiceProvider.FIELD_CONFIG, JsonUtils.writeValueAsString((Object)value.getConfig()));
            gen.writeStringField(SamlServiceProvider.FIELD_ID, value.getId());
            gen.writeStringField(SamlServiceProvider.FIELD_ENTITY_ID, value.getEntityId());
            gen.writeStringField(SamlServiceProvider.FIELD_NAME, value.getName());
            gen.writeNumberField(SamlServiceProvider.FIELD_VERSION, value.getVersion());
            this.writeDateField(SamlServiceProvider.FIELD_CREATED, value.getCreated(), gen);
            this.writeDateField(SamlServiceProvider.FIELD_LAST_MODIFIED, value.getLastModified(), gen);
            gen.writeBooleanField(SamlServiceProvider.FIELD_ACTIVE, value.isActive());
            gen.writeStringField(SamlServiceProvider.FIELD_IDENTITY_ZONE_ID, value.getIdentityZoneId());
            gen.writeEndObject();
        }

        public void writeDateField(String fieldName, Date value, JsonGenerator gen) throws IOException {
            if (value != null) {
                gen.writeNumberField(fieldName, value.getTime());
            } else {
                gen.writeNullField(fieldName);
            }
        }
    }
}

