/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import org.cloudfoundry.identity.uaa.scim.ScimMeta;
import org.springframework.util.Assert;

public abstract class ScimCore<T extends ScimCore> {
    public static final String[] SCHEMAS = new String[]{"urn:scim:schemas:core:1.0"};
    private String id;
    private String externalId;
    private ScimMeta meta = new ScimMeta();

    protected ScimCore(String id) {
        this.id = id;
    }

    protected ScimCore() {
    }

    public void setSchemas(String[] schemas) {
        Assert.isTrue((boolean)Arrays.equals(SCHEMAS, schemas), (String)("Only schema '" + SCHEMAS[0] + "' is currently supported"));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public ScimCore setExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    public ScimMeta getMeta() {
        return this.meta;
    }

    public void setMeta(ScimMeta meta) {
        this.meta = meta;
    }

    @JsonIgnore
    public void setVersion(int version) {
        this.meta.setVersion(version);
    }

    @JsonIgnore
    public int getVersion() {
        return this.meta.getVersion();
    }

    public String[] getSchemas() {
        return SCHEMAS;
    }

    public void patch(T patch) {
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ScimCore) {
            ScimCore other = (ScimCore)o;
            return this.id.equals(other.id);
        }
        if (o instanceof String) {
            String otherId = (String)o;
            return this.id.equals(otherId);
        }
        return false;
    }
}

