/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.client;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ClientDetailsModification
extends BaseClientDetails {
    public static final String ADD = "add";
    public static final String UPDATE = "update";
    public static final String UPDATE_SECRET = "update,secret";
    public static final String DELETE = "delete";
    public static final String SECRET = "secret";
    public static final String NONE = "none";
    @JsonIgnore
    private String action = "none";

    public ClientDetailsModification() {
    }

    public ClientDetailsModification(ClientDetails prototype) {
        super(prototype);
        if (prototype instanceof BaseClientDetails) {
            BaseClientDetails baseClientDetails = (BaseClientDetails)prototype;
            this.setAdditionalInformation(baseClientDetails.getAdditionalInformation());
            if (baseClientDetails.getAutoApproveScopes() != null) {
                this.setAutoApproveScopes(baseClientDetails.getAutoApproveScopes());
            }
        }
        if (prototype instanceof ClientDetailsModification) {
            this.action = ((ClientDetailsModification)prototype).getAction();
            this.setApprovalsDeleted(((ClientDetailsModification)prototype).isApprovalsDeleted());
        }
    }

    @JsonGetter(value="action")
    private String getActionForSerialization() {
        if (this.action == NONE) {
            return null;
        }
        return this.getAction();
    }

    @JsonSetter(value="action")
    private void setActionWithoutValidation(String action) {
        this.action = action;
    }

    @JsonIgnore
    public String getAction() {
        return this.action;
    }

    @JsonIgnore
    public void setAction(String action) {
        if (!this.valid(action)) {
            throw new IllegalArgumentException("Invalid action:" + action);
        }
        this.action = action;
    }

    @JsonIgnore
    public boolean isApprovalsDeleted() {
        if (this.getAdditionalInformation().get("approvals_deleted") != null) {
            return Boolean.TRUE.equals(this.getAdditionalInformation().get("approvals_deleted"));
        }
        return false;
    }

    @JsonIgnore
    public void setApprovalsDeleted(boolean approvalsDeleted) {
        this.addAdditionalInformation("approvals_deleted", approvalsDeleted);
    }

    @JsonIgnore
    private boolean valid(String action) {
        return ADD.equals(action) || UPDATE.equals(action) || DELETE.equals(action) || UPDATE_SECRET.equals(action) || SECRET.equals(action);
    }
}

