/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.oauth.token;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TokenConstants {
    public static final String REQUEST_TOKEN_FORMAT = "token_format";
    public static final String OPAQUE = "opaque";
    public static final String GRANT_TYPE_USER_TOKEN = "user_token";
    public static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    public static final String USER_TOKEN_REQUESTING_CLIENT_ID = "requesting_client_id";
    public static final String REFRESH_TOKEN_SUFFIX = "-r";
    public static final String GRANT_TYPE_SAML2_BEARER = "urn:ietf:params:oauth:grant-type:saml2-bearer";
    public static final String GRANT_TYPE_JWT_BEARER = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    public static final String ID_TOKEN_HINT_PROMPT = "prompt";
    public static final String ID_TOKEN_HINT_PROMPT_NONE = "none";

    public static enum TokenFormat {
        OPAQUE("opaque"),
        JWT("jwt");

        private String stringValue;

        private TokenFormat(String string2) {
            this.stringValue = string2;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public static TokenFormat fromStringValue(String stringValue) {
            for (TokenFormat tokenFormat : TokenFormat.values()) {
                if (!tokenFormat.stringValue.equalsIgnoreCase(stringValue)) continue;
                return tokenFormat;
            }
            return null;
        }

        public static List<String> getStringValues() {
            return Arrays.asList(TokenFormat.values()).stream().map(format -> format.getStringValue()).collect(Collectors.toList());
        }
    }
}

