/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.provider.saml.idp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SamlServiceProviderDefinition {
    private String metaDataLocation;
    private String nameID;
    private int singleSignOnServiceIndex;
    private boolean metadataTrustCheck;
    private boolean skipSslValidation = false;
    private Map<String, Object> attributeMappings = new HashMap<String, Object>();
    private boolean enableIdpInitiatedSso = false;
    private Map<String, Object> staticCustomAttributes = new HashMap<String, Object>();

    public SamlServiceProviderDefinition clone() {
        return new SamlServiceProviderDefinition(this.metaDataLocation, this.nameID, this.singleSignOnServiceIndex, this.metadataTrustCheck, this.skipSslValidation, this.attributeMappings, this.enableIdpInitiatedSso);
    }

    public SamlServiceProviderDefinition() {
    }

    private SamlServiceProviderDefinition(String metaDataLocation, String nameID, int singleSignOnServiceIndex, boolean metadataTrustCheck, boolean skipSslValidation, Map<String, Object> attributeMappings, boolean enableIdpInitiatedSso) {
        this.metaDataLocation = metaDataLocation;
        this.nameID = nameID;
        this.singleSignOnServiceIndex = singleSignOnServiceIndex;
        this.metadataTrustCheck = metadataTrustCheck;
        this.skipSslValidation = skipSslValidation;
        this.attributeMappings = attributeMappings;
        this.enableIdpInitiatedSso = enableIdpInitiatedSso;
    }

    @JsonIgnore
    public MetadataLocation getType() {
        String trimmedLocation = this.metaDataLocation.trim();
        if (trimmedLocation.startsWith("<?xml") || trimmedLocation.startsWith("<md:EntityDescriptor") || trimmedLocation.startsWith("<EntityDescriptor")) {
            try {
                this.validateXml(trimmedLocation);
                return MetadataLocation.DATA;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (trimmedLocation.startsWith("http")) {
            try {
                URL uri = new URL(trimmedLocation);
                return MetadataLocation.URL;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return MetadataLocation.UNKNOWN;
    }

    protected void validateXml(String xml) throws IllegalArgumentException {
        if (xml == null || xml.toUpperCase().contains("<!DOCTYPE")) {
            throw new IllegalArgumentException("Invalid metadata XML contents:" + xml);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException("Unable to create document parser.", e);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Sax Parsing exception of XML:" + xml, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException of XML:" + xml, e);
        }
    }

    public String getMetaDataLocation() {
        return this.metaDataLocation;
    }

    public void setMetaDataLocation(String metaDataLocation) {
        this.metaDataLocation = metaDataLocation;
    }

    public String getNameID() {
        return this.nameID;
    }

    public void setNameID(String nameID) {
        this.nameID = nameID;
    }

    public int getSingleSignOnServiceIndex() {
        return this.singleSignOnServiceIndex;
    }

    public void setSingleSignOnServiceIndex(int singleSignOnServiceIndex) {
        this.singleSignOnServiceIndex = singleSignOnServiceIndex;
    }

    public boolean isMetadataTrustCheck() {
        return this.metadataTrustCheck;
    }

    public void setMetadataTrustCheck(boolean metadataTrustCheck) {
        this.metadataTrustCheck = metadataTrustCheck;
    }

    public int hashCode() {
        int result = this.metaDataLocation != null ? this.metaDataLocation.hashCode() : 0;
        result = 31 * result + (this.nameID != null ? this.nameID.hashCode() : 0);
        result = 31 * result + this.singleSignOnServiceIndex;
        result = 31 * result + (this.metadataTrustCheck ? 1 : 0);
        result = 31 * result + (this.skipSslValidation ? 1 : 0);
        result = 31 * result + (this.attributeMappings != null ? this.attributeMappings.hashCode() : 0);
        return result;
    }

    public boolean isSkipSslValidation() {
        return this.skipSslValidation;
    }

    public void setSkipSslValidation(boolean skipSslValidation) {
        this.skipSslValidation = skipSslValidation;
    }

    public void setAttributeMappings(Map<String, Object> attributeMappings) {
        this.attributeMappings = attributeMappings;
    }

    public Map<String, Object> getAttributeMappings() {
        return this.attributeMappings;
    }

    public boolean isEnableIdpInitiatedSso() {
        return this.enableIdpInitiatedSso;
    }

    public void setEnableIdpInitiatedSso(boolean enableIdpInitiatedSso) {
        this.enableIdpInitiatedSso = enableIdpInitiatedSso;
    }

    public Map<String, Object> getStaticCustomAttributes() {
        return this.staticCustomAttributes;
    }

    public void setStaticCustomAttributes(Map<String, Object> staticCustomAttributes) {
        this.staticCustomAttributes = staticCustomAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlServiceProviderDefinition that = (SamlServiceProviderDefinition)o;
        if (this.singleSignOnServiceIndex != that.singleSignOnServiceIndex) {
            return false;
        }
        if (this.metadataTrustCheck != that.metadataTrustCheck) {
            return false;
        }
        if (this.skipSslValidation != that.skipSslValidation) {
            return false;
        }
        if (this.metaDataLocation != null ? !this.metaDataLocation.equals(that.metaDataLocation) : that.metaDataLocation != null) {
            return false;
        }
        if (this.nameID != null ? !this.nameID.equals(that.nameID) : that.nameID != null) {
            return false;
        }
        return this.attributeMappings != null ? this.attributeMappings.equals(that.attributeMappings) : that.attributeMappings == null;
    }

    public String toString() {
        return "SamlServiceProviderDefinition{metaDataLocation='" + this.metaDataLocation + '\'' + ", nameID='" + this.nameID + '\'' + ", singleSignOnServiceIndex=" + this.singleSignOnServiceIndex + ", metadataTrustCheck=" + this.metadataTrustCheck + ", skipSslValidation=" + this.skipSslValidation + ", attributeMappings=" + this.attributeMappings + '}';
    }

    public static class Builder {
        private String metaDataLocation;
        private String nameID;
        private int singleSignOnServiceIndex;
        private boolean metadataTrustCheck;
        private boolean enableIdpInitiatedSso = false;

        private Builder() {
        }

        public static Builder get() {
            return new Builder();
        }

        public SamlServiceProviderDefinition build() {
            SamlServiceProviderDefinition def = new SamlServiceProviderDefinition();
            def.setMetaDataLocation(this.metaDataLocation);
            def.setNameID(this.nameID);
            def.setSingleSignOnServiceIndex(this.singleSignOnServiceIndex);
            def.setMetadataTrustCheck(this.metadataTrustCheck);
            def.setEnableIdpInitiatedSso(this.enableIdpInitiatedSso);
            return def;
        }

        public Builder setMetaDataLocation(String metaDataLocation) {
            this.metaDataLocation = metaDataLocation;
            return this;
        }

        public Builder setNameID(String nameID) {
            this.nameID = nameID;
            return this;
        }

        public Builder setSingleSignOnServiceIndex(int singleSignOnServiceIndex) {
            this.singleSignOnServiceIndex = singleSignOnServiceIndex;
            return this;
        }

        public Builder setMetadataTrustCheck(boolean metadataTrustCheck) {
            this.metadataTrustCheck = metadataTrustCheck;
            return this;
        }

        public Builder setEnableIdpInitiatedSso(boolean enableIdpInitiatedSso) {
            this.enableIdpInitiatedSso = enableIdpInitiatedSso;
            return this;
        }
    }

    public static enum MetadataLocation {
        URL,
        DATA,
        UNKNOWN;

    }
}

