/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.cloudfoundry.identity.uaa.approval.Approval;
import org.cloudfoundry.identity.uaa.impl.JsonDateDeserializer;
import org.cloudfoundry.identity.uaa.scim.ScimMeta;
import org.cloudfoundry.identity.uaa.scim.ScimUser;

public class ScimUserJsonDeserializer
extends JsonDeserializer<ScimUser> {
    public ScimUser deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ScimUser user = new ScimUser();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            if (jp.getCurrentToken() != JsonToken.FIELD_NAME) continue;
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("id".equalsIgnoreCase(fieldName)) {
                user.setId((String)jp.readValueAs(String.class));
                continue;
            }
            if ("userName".equalsIgnoreCase(fieldName)) {
                user.setUserName((String)jp.readValueAs(String.class));
                continue;
            }
            if ("externalId".equalsIgnoreCase(fieldName)) {
                user.setExternalId((String)jp.readValueAs(String.class));
                continue;
            }
            if ("meta".equalsIgnoreCase(fieldName)) {
                user.setMeta((ScimMeta)jp.readValueAs(ScimMeta.class));
                continue;
            }
            if ("schemas".equalsIgnoreCase(fieldName)) {
                user.setSchemas((String[])jp.readValueAs(String[].class));
                continue;
            }
            if ("userType".equalsIgnoreCase(fieldName)) {
                user.setUserType((String)jp.readValueAs(String.class));
                continue;
            }
            if ("title".equalsIgnoreCase(fieldName)) {
                user.setTitle((String)jp.readValueAs(String.class));
                continue;
            }
            if ("timezone".equalsIgnoreCase(fieldName)) {
                user.setTimezone((String)jp.readValueAs(String.class));
                continue;
            }
            if ("profileUrl".equalsIgnoreCase(fieldName)) {
                user.setProfileUrl((String)jp.readValueAs(String.class));
                continue;
            }
            if ("preferredLanguage".equalsIgnoreCase(fieldName)) {
                user.setPreferredLanguage((String)jp.readValueAs(String.class));
                continue;
            }
            if ("phoneNumbers".equalsIgnoreCase(fieldName)) {
                ScimUser.PhoneNumber[] phoneNumbers = (ScimUser.PhoneNumber[])jp.readValueAs(ScimUser.PhoneNumber[].class);
                if (phoneNumbers != null) {
                    user.setPhoneNumbers(Arrays.asList(phoneNumbers));
                    continue;
                }
                user.setPhoneNumbers(new ArrayList<ScimUser.PhoneNumber>());
                continue;
            }
            if ("password".equalsIgnoreCase(fieldName)) {
                user.setPassword((String)jp.readValueAs(String.class));
                continue;
            }
            if ("nickname".equalsIgnoreCase(fieldName)) {
                user.setNickName((String)jp.readValueAs(String.class));
                continue;
            }
            if ("name".equalsIgnoreCase(fieldName)) {
                user.setName((ScimUser.Name)jp.readValueAs(ScimUser.Name.class));
                continue;
            }
            if ("locale".equalsIgnoreCase(fieldName)) {
                user.setLocale((String)jp.readValueAs(String.class));
                continue;
            }
            if ("emails".equalsIgnoreCase(fieldName)) {
                user.setEmails(Arrays.asList((Object[])jp.readValueAs(ScimUser.Email[].class)));
                continue;
            }
            if ("groups".equalsIgnoreCase(fieldName)) {
                user.setGroups(Arrays.asList((Object[])jp.readValueAs(ScimUser.Group[].class)));
                continue;
            }
            if ("displayName".equalsIgnoreCase(fieldName)) {
                user.setDisplayName((String)jp.readValueAs(String.class));
                continue;
            }
            if ("active".equalsIgnoreCase(fieldName)) {
                user.setActive((Boolean)jp.readValueAs(Boolean.class));
                continue;
            }
            if ("verified".equalsIgnoreCase(fieldName)) {
                user.setVerified((Boolean)jp.readValueAs(Boolean.class));
                continue;
            }
            if ("origin".equalsIgnoreCase(fieldName)) {
                user.setOrigin((String)jp.readValueAs(String.class));
                continue;
            }
            if ("externalId".equalsIgnoreCase(fieldName)) {
                user.setExternalId((String)jp.readValueAs(String.class));
                continue;
            }
            if ("zoneId".equalsIgnoreCase(fieldName)) {
                user.setZoneId((String)jp.readValueAs(String.class));
                continue;
            }
            if ("salt".equalsIgnoreCase(fieldName)) {
                user.setSalt((String)jp.readValueAs(String.class));
                continue;
            }
            if ("passwordLastModified".equalsIgnoreCase(fieldName)) {
                if (jp.getValueAsString() == null) continue;
                user.setPasswordLastModified(JsonDateDeserializer.getDate(jp.getValueAsString(), jp.getCurrentLocation()));
                continue;
            }
            if ("approvals".equalsIgnoreCase(fieldName)) {
                user.setApprovals(new HashSet<Object>(Arrays.asList((Object[])jp.readValueAs(Approval[].class))));
                continue;
            }
            if ("lastLogonTime".equalsIgnoreCase(fieldName)) {
                if (jp.getValueAsString() == null) continue;
                user.setLastLogonTime(jp.getValueAsLong());
                continue;
            }
            if ("previousLogonTime".equalsIgnoreCase(fieldName)) {
                if (jp.getValueAsString() == null) continue;
                user.setPreviousLogonTime(jp.getValueAsLong());
                continue;
            }
            throw new UnrecognizedPropertyException("unrecognized field", jp.getCurrentLocation(), ScimUser.class, fieldName, Collections.emptySet());
        }
        return user;
    }
}

