/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.zone;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ZoneManagementScopes {
    public static final String ZONE_ID_MATCH = "{zone.id}";
    public static final String ZONES_ZONE_ID_PREFIX = "zones.";
    public static final String ZONES_ZONE_ID_ADMIN = "zones.{zone.id}.admin";
    public static final String ZONE_SCOPES_SUFFIX = "(admin|read|clients.(admin|read|write)|scim.(create|read|write)|idps.read)$";
    public static final String ZONE_MANAGING_SCOPE_REGEX = "^zones\\.[^\\.]+\\.(admin|read|clients.(admin|read|write)|scim.(create|read|write)|idps.read)$";
    public static final String[] ZONE_SWITCH_SCOPES = new String[]{"zones.{zone.id}.admin", "uaa.admin", "zones.{zone.id}.read", "zones.{zone.id}.clients.admin", "zones.{zone.id}.clients.read", "zones.{zone.id}.clients.write", "zones.{zone.id}.scim.read", "zones.{zone.id}.scim.write", "zones.{zone.id}.scim.create", "zones.{zone.id}.idps.read", "zones.{zone.id}.idps.write", "zones.{zone.id}.sps.read", "zones.{zone.id}.sps.write", "zones.{zone.id}.scim.invite"};
    public static final List<String> UAA_SCOPES = Collections.unmodifiableList(Arrays.asList("zones.read", "zones.write", "zones.*.admin", "zones.*.read", "zones.*.clients.admin", "zones.*.clients.read", "zones.*.clients.write", "zones.*.scim.create", "zones.*.scim.read", "zones.*.scim.write", "zones.*.idps.read", "zones.*.idps.write", "zones.*.sps.write", "zones.*.sps.read", "sps.write", "sps.read", "idps.read", "idps.write", "clients.admin", "clients.write", "clients.read", "clients.secret", "scim.write", "scim.read", "scim.create", "scim.userids", "scim.zones", "groups.update", "password.write", "oauth.login", "uaa.admin"));

    public static List<String> getSystemScopes() {
        return UAA_SCOPES.stream().filter(s -> !s.startsWith(ZONES_ZONE_ID_PREFIX)).collect(Collectors.toList());
    }

    public static String[] getZoneSwitchingScopes(String identityZoneId) {
        String[] result = new String[ZONE_SWITCH_SCOPES.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ZONE_SWITCH_SCOPES[i].replace(ZONE_ID_MATCH, identityZoneId);
        }
        return result;
    }
}

