/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authorization.external;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authorization.ExternalGroupMappingAuthorizationManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.util.StringUtils;

public class LdapGroupMappingAuthorizationManager
implements ExternalGroupMappingAuthorizationManager {
    private ScimGroupExternalMembershipManager externalMembershipManager;
    private ScimGroupProvisioning scimGroupProvisioning;
    private static final Log logger = LogFactory.getLog(LdapGroupMappingAuthorizationManager.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static final String EXTERNAL_GROUP_KEY = "externalGroups.";

    public LdapGroupMappingAuthorizationManager() {
        mapper.setSerializationConfig(mapper.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_NULL));
    }

    public Set<String> findScopesFromAuthorities(String authorities) {
        LinkedHashSet<String> authorityList = new LinkedHashSet<String>();
        if (StringUtils.hasLength((String)authorities)) {
            Map incomingExternalGroupMap = null;
            try {
                incomingExternalGroupMap = (Map)mapper.readValue(authorities.getBytes(), Map.class);
            }
            catch (Throwable t) {
                logger.error((Object)"Unable to read external groups", t);
            }
            if (null != incomingExternalGroupMap) {
                HashSet externalGroups = new HashSet();
                int i = 0;
                while (incomingExternalGroupMap.containsKey(EXTERNAL_GROUP_KEY + i)) {
                    externalGroups.add(incomingExternalGroupMap.get(EXTERNAL_GROUP_KEY + i));
                    ++i;
                }
                LinkedHashSet<ScimGroupExternalMember> externalGroupMaps = new LinkedHashSet<ScimGroupExternalMember>();
                for (String externalGroup : externalGroups) {
                    externalGroupMaps.addAll(this.externalMembershipManager.getExternalGroupMapsByExternalGroup(externalGroup));
                }
                for (ScimGroupExternalMember externalGroupMap : externalGroupMaps) {
                    ScimGroup scimGroup = (ScimGroup)this.scimGroupProvisioning.retrieve(externalGroupMap.getGroupId());
                    authorityList.add(scimGroup.getDisplayName());
                }
            }
        }
        return authorityList;
    }

    public void setExternalMembershipManager(ScimGroupExternalMembershipManager externalMembershipManager) {
        this.externalMembershipManager = externalMembershipManager;
    }

    public void setScimGroupProvisioning(ScimGroupProvisioning scimGroupProvisioning) {
        this.scimGroupProvisioning = scimGroupProvisioning;
    }
}

