/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.password.event;

import java.security.Principal;
import java.util.List;
import org.cloudfoundry.identity.uaa.audit.event.AbstractUaaEvent;
import org.cloudfoundry.identity.uaa.password.event.PasswordChangeEvent;
import org.cloudfoundry.identity.uaa.password.event.PasswordFailureEvent;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.core.context.SecurityContextHolder;

public class PasswordChangeEventPublisher
implements ApplicationEventPublisherAware {
    private ScimUserProvisioning dao;
    private ApplicationEventPublisher publisher;

    public PasswordChangeEventPublisher(ScimUserProvisioning provisioning) {
        this.dao = provisioning;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void passwordFailure(String userId, Exception e) {
        UaaUser client = this.getUser(userId);
        if (client == null) {
            this.publish(new PasswordFailureEvent(e.getMessage(), client, this.getPrincipal()));
        } else {
            this.publish(new PasswordFailureEvent(e.getMessage(), this.getPrincipal()));
        }
    }

    public void passwordChange(String userId) {
        this.publish(new PasswordChangeEvent("Password changed", this.getUser(userId), this.getPrincipal()));
    }

    private UaaUser getUser(String userId) {
        try {
            ScimUser scimUser = (ScimUser)this.dao.retrieve(userId);
            if (scimUser != null) {
                return new UaaUser(scimUser.getUserName(), "N/A", this.getEmail(scimUser), scimUser.getGivenName(), scimUser.getFamilyName());
            }
        }
        catch (ScimResourceNotFoundException scimResourceNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private String getEmail(ScimUser scimUser) {
        List<ScimUser.Email> emails = scimUser.getEmails();
        if (emails == null || emails.isEmpty()) {
            return scimUser.getUserName().contains("@") ? scimUser.getUserName() : String.valueOf(scimUser.getUserName()) + "@unknown.org";
        }
        for (ScimUser.Email email : emails) {
            if (!email.isPrimary()) continue;
            return email.getValue();
        }
        return scimUser.getEmails().get(0).getValue();
    }

    private Principal getPrincipal() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    private void publish(AbstractUaaEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent((ApplicationEvent)event);
        }
    }
}

