/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;
import org.cloudfoundry.identity.uaa.scim.ScimMeta;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

public class ScimGroupJsonDeserializer
extends JsonDeserializer<ScimGroup> {
    public ScimGroup deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ScimGroup group = new ScimGroup();
        HashMap roles = new HashMap();
        ScimGroupMember.Role[] roleArray = ScimGroupMember.Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScimGroupMember.Role role = roleArray[n2];
            roles.put(role, new ArrayList());
            ++n2;
        }
        HashSet<ScimGroupMember> allMembers = new HashSet<ScimGroupMember>();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            ScimGroupMember[] members;
            ScimGroupMember.Role role;
            if (jp.getCurrentToken() != JsonToken.FIELD_NAME) continue;
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("id".equalsIgnoreCase(fieldName)) {
                group.setId((String)jp.readValueAs(String.class));
                continue;
            }
            if ("displayname".equalsIgnoreCase(fieldName)) {
                group.setDisplayName((String)jp.readValueAs(String.class));
                continue;
            }
            if ("meta".equalsIgnoreCase(fieldName)) {
                group.setMeta((ScimMeta)jp.readValueAs(ScimMeta.class));
                continue;
            }
            if ("schemas".equalsIgnoreCase(fieldName)) {
                group.setSchemas((String[])jp.readValueAs(String[].class));
                continue;
            }
            String value = fieldName.substring(0, fieldName.length() - 1);
            try {
                role = ScimGroupMember.Role.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                role = null;
            }
            if (role == null) continue;
            ScimGroupMember[] scimGroupMemberArray = members = (ScimGroupMember[])jp.readValueAs(ScimGroupMember[].class);
            int n3 = members.length;
            int n4 = 0;
            while (n4 < n3) {
                ScimGroupMember member = scimGroupMemberArray[n4];
                member.setRoles(new ArrayList<ScimGroupMember.Role>());
                ++n4;
            }
            ((List)roles.get((Object)role)).addAll(Arrays.asList(members));
            allMembers.addAll(Arrays.asList(members));
        }
        for (ScimGroupMember member : allMembers) {
            for (ScimGroupMember.Role role : roles.keySet()) {
                if (!((List)roles.get((Object)role)).contains(member)) continue;
                member.getRoles().add(role);
            }
        }
        group.setMembers(new ArrayList<ScimGroupMember>(allMembers));
        return group;
    }
}

