/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim;

import java.util.Arrays;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ScimGroupMember {
    public static final List<Role> GROUP_MEMBER = Arrays.asList(Role.MEMBER);
    public static final List<Role> GROUP_ADMIN = Arrays.asList(Role.READER, Role.WRITER);
    @JsonProperty(value="value")
    private String memberId;
    private Type type;
    @JsonIgnore
    private List<Role> roles;

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> permissions) {
        this.roles = permissions;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        return String.format("(memberId: %s, type: %s, roles: %s)", new Object[]{this.memberId, this.type, this.roles});
    }

    public int hashCode() {
        int hc = 0x1F ^ this.memberId.hashCode();
        return hc ^= this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ScimGroupMember)) {
            return false;
        }
        ScimGroupMember other = (ScimGroupMember)o;
        return this.memberId.equals(other.memberId) && this.type.equals((Object)other.type);
    }

    public ScimGroupMember() {
    }

    public ScimGroupMember(String memberId) {
        this(memberId, Type.USER, GROUP_MEMBER);
    }

    public ScimGroupMember(String memberId, Type type, List<Role> roles) {
        this.memberId = memberId;
        this.type = type;
        this.roles = roles;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static enum Role {
        MEMBER,
        READER,
        WRITER;

    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static enum Type {
        USER,
        GROUP;

    }
}

