/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.cloudfoundry.identity.uaa.oauth.approval.Approval;
import org.cloudfoundry.identity.uaa.scim.ScimCore;
import org.cloudfoundry.identity.uaa.scim.ScimUserJsonDeserializer;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.util.Assert;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonDeserialize(using=ScimUserJsonDeserializer.class)
public final class ScimUser
extends ScimCore {
    private String userName;
    private Name name;
    private List<Email> emails;
    private Set<Group> groups;
    private Set<Approval> approvals;
    private List<PhoneNumber> phoneNumbers;
    private String displayName;
    private String nickName;
    private String profileUrl;
    private String title;
    private String userType;
    private String preferredLanguage;
    private String locale;
    private String timezone;
    private boolean active = true;
    @JsonProperty
    private String password;

    public ScimUser() {
    }

    public ScimUser(String id, String userName, String givenName, String familyName) {
        super(id);
        this.userName = userName;
        this.name = new Name(givenName, familyName);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public List<Email> getEmails() {
        return this.emails;
    }

    public void setEmails(List<Email> emails) {
        this.emails = emails;
    }

    public Set<Approval> getApprovals() {
        return this.approvals;
    }

    public void setApprovals(Set<Approval> approvals) {
        this.approvals = approvals;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<Group> groups) {
        this.groups = new LinkedHashSet<Group>(groups);
    }

    public List<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<PhoneNumber> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @JsonIgnore
    public String getPrimaryEmail() {
        if (this.getEmails() == null || this.getEmails().isEmpty()) {
            return null;
        }
        Email primaryEmail = null;
        for (Email email : this.getEmails()) {
            if (!email.isPrimary()) continue;
            primaryEmail = email;
            break;
        }
        if (primaryEmail == null) {
            primaryEmail = this.getEmails().get(0);
        }
        return primaryEmail.getValue();
    }

    @JsonIgnore
    public String getGivenName() {
        return this.name == null ? null : this.name.getGivenName();
    }

    @JsonIgnore
    public String getFamilyName() {
        return this.name == null ? null : this.name.getFamilyName();
    }

    public void addEmail(String newEmail) {
        Assert.hasText((String)newEmail);
        if (this.emails == null) {
            this.emails = new ArrayList<Email>(1);
        }
        for (Email email : this.emails) {
            if (!email.value.equals(newEmail)) continue;
            throw new IllegalArgumentException("Already contains email " + newEmail);
        }
        Email e = new Email();
        e.setValue(newEmail);
        this.emails.add(e);
    }

    public void addPhoneNumber(String newPhoneNumber) {
        Assert.hasText((String)newPhoneNumber);
        if (this.phoneNumbers == null) {
            this.phoneNumbers = new ArrayList<PhoneNumber>(1);
        }
        for (PhoneNumber email : this.phoneNumbers) {
            if (!email.value.equals(newPhoneNumber) || email.getType() != null) continue;
            throw new IllegalArgumentException("Already contains phoneNumber " + newPhoneNumber);
        }
        PhoneNumber e = new PhoneNumber();
        e.setValue(newPhoneNumber);
        this.phoneNumbers.add(e);
    }

    public List<String> wordList() {
        ArrayList<String> words = new ArrayList<String>();
        if (this.userName != null) {
            words.add(this.userName);
        }
        if (this.name != null) {
            if (this.name.givenName != null) {
                words.add(this.name.givenName);
            }
            if (this.name.familyName != null) {
                words.add(this.name.familyName);
            }
            if (this.nickName != null) {
                words.add(this.nickName);
            }
        }
        if (this.emails != null) {
            for (Email email : this.emails) {
                words.add(email.getValue());
            }
        }
        return words;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    public static final class Email {
        private String value;
        private String type;
        private boolean primary = false;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        public boolean isPrimary() {
            return this.primary;
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static final class Group {
        String value;
        String display;
        Type type;

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public Group() {
            this(null, null);
        }

        public Group(String value, String display) {
            this(value, display, Type.DIRECT);
        }

        public Group(String value, String display, Type type) {
            this.value = value;
            this.display = display;
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDisplay() {
            return this.display;
        }

        public void setDisplay(String display) {
            this.display = display;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.display == null ? 0 : this.display.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Group other = (Group)obj;
            if (this.display == null ? other.display != null : !this.display.equals(other.display)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            return String.format("(id: %s, name: %s, type: %s)", new Object[]{this.value, this.display, this.type});
        }

        public static enum Type {
            DIRECT,
            INDIRECT;

        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static final class Name {
        String formatted;
        String familyName;
        String givenName;
        String middleName;
        String honorificPrefix;
        String honorificSuffix;

        public Name() {
        }

        public Name(String givenName, String familyName) {
            this.givenName = givenName;
            this.familyName = familyName;
            this.formatted = String.valueOf(givenName) + " " + familyName;
        }

        public String getFormatted() {
            return this.formatted;
        }

        public void setFormatted(String formatted) {
            this.formatted = formatted;
        }

        public String getFamilyName() {
            return this.familyName;
        }

        public void setFamilyName(String familyName) {
            this.familyName = familyName;
        }

        public String getGivenName() {
            return this.givenName;
        }

        public void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public String getMiddleName() {
            return this.middleName;
        }

        public void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        public String getHonorificPrefix() {
            return this.honorificPrefix;
        }

        public void setHonorificPrefix(String honorificPrefix) {
            this.honorificPrefix = honorificPrefix;
        }

        public String getHonorificSuffix() {
            return this.honorificSuffix;
        }

        public void setHonorificSuffix(String honorificSuffix) {
            this.honorificSuffix = honorificSuffix;
        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    public static final class PhoneNumber {
        private String value;
        private String type;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

