/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.cloudfoundry.identity.uaa.oauth.approval.Approval;
import org.cloudfoundry.identity.uaa.scim.ScimMeta;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.exc.UnrecognizedPropertyException;

public class ScimUserJsonDeserializer
extends JsonDeserializer<ScimUser> {
    public ScimUser deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ScimUser user = new ScimUser();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            if (jp.getCurrentToken() != JsonToken.FIELD_NAME) continue;
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("id".equalsIgnoreCase(fieldName)) {
                user.setId((String)jp.readValueAs(String.class));
                continue;
            }
            if ("userName".equalsIgnoreCase(fieldName)) {
                user.setUserName((String)jp.readValueAs(String.class));
                continue;
            }
            if ("externalId".equalsIgnoreCase(fieldName)) {
                user.setExternalId((String)jp.readValueAs(String.class));
                continue;
            }
            if ("meta".equalsIgnoreCase(fieldName)) {
                user.setMeta((ScimMeta)jp.readValueAs(ScimMeta.class));
                continue;
            }
            if ("schemas".equalsIgnoreCase(fieldName)) {
                user.setSchemas((String[])jp.readValueAs(String[].class));
                continue;
            }
            if ("userType".equalsIgnoreCase(fieldName)) {
                user.setUserType((String)jp.readValueAs(String.class));
                continue;
            }
            if ("title".equalsIgnoreCase(fieldName)) {
                user.setTitle((String)jp.readValueAs(String.class));
                continue;
            }
            if ("timezone".equalsIgnoreCase(fieldName)) {
                user.setTimezone((String)jp.readValueAs(String.class));
                continue;
            }
            if ("profileUrl".equalsIgnoreCase(fieldName)) {
                user.setProfileUrl((String)jp.readValueAs(String.class));
                continue;
            }
            if ("preferredLanguage".equalsIgnoreCase(fieldName)) {
                user.setPreferredLanguage((String)jp.readValueAs(String.class));
                continue;
            }
            if ("phoneNumbers".equalsIgnoreCase(fieldName)) {
                user.setPhoneNumbers(Arrays.asList((ScimUser.PhoneNumber[])jp.readValueAs(ScimUser.PhoneNumber[].class)));
                continue;
            }
            if ("password".equalsIgnoreCase(fieldName)) {
                user.setPassword((String)jp.readValueAs(String.class));
                continue;
            }
            if ("nickname".equalsIgnoreCase(fieldName)) {
                user.setNickName((String)jp.readValueAs(String.class));
                continue;
            }
            if ("name".equalsIgnoreCase(fieldName)) {
                user.setName((ScimUser.Name)jp.readValueAs(ScimUser.Name.class));
                continue;
            }
            if ("locale".equalsIgnoreCase(fieldName)) {
                user.setLocale((String)jp.readValueAs(String.class));
                continue;
            }
            if ("emails".equalsIgnoreCase(fieldName)) {
                user.setEmails(Arrays.asList((ScimUser.Email[])jp.readValueAs(ScimUser.Email[].class)));
                continue;
            }
            if ("groups".equalsIgnoreCase(fieldName)) {
                user.setGroups(Arrays.asList((ScimUser.Group[])jp.readValueAs(ScimUser.Group[].class)));
                continue;
            }
            if ("displayName".equalsIgnoreCase(fieldName)) {
                user.setDisplayName((String)jp.readValueAs(String.class));
                continue;
            }
            if ("active".equalsIgnoreCase(fieldName)) {
                user.setActive((Boolean)jp.readValueAs(Boolean.class));
                continue;
            }
            if ("approvals".equalsIgnoreCase(fieldName)) {
                user.setApprovals(new HashSet<Approval>(Arrays.asList((Approval[])jp.readValueAs(Approval[].class))));
                continue;
            }
            throw new UnrecognizedPropertyException("unrecognized field", jp.getCurrentLocation(), ScimUser.class, fieldName);
        }
        return user;
    }
}

