/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class ScimExternalGroupBootstrap
implements InitializingBean {
    private List<Map<String, String>> externalGroupMap;
    private final ScimGroupProvisioning scimGroupProvisioning;
    private final ScimGroupExternalMembershipManager externalMembershipManager;
    private static final String GROUP_BY_NAME_FILTER = "displayName eq '%s'";
    private final Log logger = LogFactory.getLog(this.getClass());

    public ScimExternalGroupBootstrap(ScimGroupProvisioning scimGroupProvisioning, ScimGroupExternalMembershipManager externalMembershipManager) {
        this.scimGroupProvisioning = scimGroupProvisioning;
        this.externalMembershipManager = externalMembershipManager;
        this.externalGroupMap = new ArrayList<Map<String, String>>();
    }

    public void setExternalGroupMap(Set<String> externalGroupMaps) {
        for (String line : externalGroupMaps) {
            String[] externalGroups;
            String[] fields = line.split("\\|");
            if (fields.length < 2) continue;
            String groupName = fields[0];
            List groups = this.scimGroupProvisioning.query(String.format(GROUP_BY_NAME_FILTER, groupName));
            if (null == groups || groups.size() != 1) continue;
            String groupId = ((ScimGroup)groups.get(0)).getId();
            if (null == fields[1] || fields[1].length() <= 0 || null == (externalGroups = fields[1].split(" ")) || externalGroups.length <= 0) continue;
            for (String externalGroup : externalGroups) {
                if (!StringUtils.hasLength((String)externalGroup.trim())) continue;
                this.externalGroupMap.add(Collections.singletonMap(groupId, externalGroup.trim()));
            }
        }
        this.logger.debug((Object)("external group map: " + this.externalGroupMap));
    }

    public void afterPropertiesSet() throws Exception {
        for (Map<String, String> groupMap : this.externalGroupMap) {
            Map.Entry<String, String> entry = groupMap.entrySet().iterator().next();
            this.addGroupMap(entry.getKey(), entry.getValue());
        }
    }

    private void addGroupMap(String groupId, String externalGroup) {
        ScimGroupExternalMember externalGroupMapping = this.externalMembershipManager.mapExternalGroup(groupId, externalGroup);
        this.logger.debug((Object)("adding external group mapping: " + externalGroupMapping));
    }
}

