/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.scim.ScimCore;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.MemberAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceAlreadyExistsException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class ScimGroupBootstrap
implements InitializingBean {
    private Set<String> groups;
    private Map<String, Set<String>> groupMembers;
    private Map<String, Set<String>> groupAdmins;
    private final ScimGroupProvisioning scimGroupProvisioning;
    private final ScimGroupMembershipManager membershipManager;
    private final ScimUserProvisioning scimUserProvisioning;
    private static final String USER_BY_NAME_FILTER = "username eq '%s'";
    private static final String GROUP_BY_NAME_FILTER = "displayName eq '%s'";
    private final Log logger = LogFactory.getLog(this.getClass());

    public ScimGroupBootstrap(ScimGroupProvisioning scimGroupProvisioning, ScimUserProvisioning scimUserProvisioning, ScimGroupMembershipManager membershipManager) {
        this.scimGroupProvisioning = scimGroupProvisioning;
        this.scimUserProvisioning = scimUserProvisioning;
        this.membershipManager = membershipManager;
        this.groups = new HashSet<String>();
        this.groupMembers = new HashMap<String, Set<String>>();
        this.groupAdmins = new HashMap<String, Set<String>>();
    }

    public void setGroups(String groups) {
        this.groups = StringUtils.commaDelimitedListToSet((String)groups);
    }

    public void setGroupMembers(List<String> membershipInfo) {
        for (String line : membershipInfo) {
            boolean groupAdmin;
            String[] fields = line.split("\\|");
            if (fields.length < 2) continue;
            Set users = StringUtils.commaDelimitedListToSet((String)fields[1]);
            String groupName = fields[0];
            this.groups.add(groupName);
            boolean bl = groupAdmin = 3 <= fields.length && "write".equalsIgnoreCase(fields[2]);
            if (groupAdmin) {
                this.groupAdmins.put(groupName, users);
                continue;
            }
            this.groupMembers.put(groupName, users);
        }
        this.logger.debug((Object)("groups: " + this.groups));
        this.logger.debug((Object)("admins: " + this.groupAdmins + ", members: " + this.groupMembers));
    }

    public void afterPropertiesSet() throws Exception {
        for (String g : this.groups) {
            this.addGroup(g);
        }
        for (String g : this.groups) {
            this.addMembers(g);
        }
    }

    private void addMembers(String g) {
        ScimGroup group = this.getGroup(g);
        if (group == null) {
            this.addGroup(g);
        }
        List<ScimGroupMember> members = this.getMembers(this.groupMembers.get(g), ScimGroupMember.GROUP_MEMBER);
        members.addAll(this.getMembers(this.groupAdmins.get(g), ScimGroupMember.GROUP_ADMIN));
        this.logger.debug((Object)("adding members: " + members + " into group: " + g));
        for (ScimGroupMember member : members) {
            try {
                this.membershipManager.addMember(group.getId(), member);
            }
            catch (MemberAlreadyExistsException ex) {
                this.logger.debug((Object)(member.getMemberId() + " already is member of group " + g));
            }
        }
    }

    private List<ScimGroupMember> getMembers(Set<String> names, List<ScimGroupMember.Role> auth) {
        if (names == null || names.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ScimGroupMember> members = new ArrayList<ScimGroupMember>();
        for (String name : names) {
            ScimCore member = this.getScimResourceId(name);
            if (member == null) continue;
            members.add(new ScimGroupMember(member.getId(), member instanceof ScimGroup ? ScimGroupMember.Type.GROUP : ScimGroupMember.Type.USER, auth));
        }
        return members;
    }

    private ScimCore getScimResourceId(String name) {
        ScimUser res = this.getUser(name);
        if (res != null) {
            return res;
        }
        this.logger.debug((Object)("user " + name + " does not exist, checking in groups..."));
        return this.getGroup(name);
    }

    private ScimUser getUser(String name) {
        List user = this.scimUserProvisioning.query(String.format(USER_BY_NAME_FILTER, name));
        if (user != null && !user.isEmpty()) {
            return (ScimUser)user.get(0);
        }
        return null;
    }

    ScimGroup getGroup(String name) {
        List g = this.scimGroupProvisioning.query(String.format(GROUP_BY_NAME_FILTER, name));
        if (g != null && !g.isEmpty()) {
            ScimGroup gr = (ScimGroup)g.get(0);
            gr.setMembers(this.membershipManager.getMembers(gr.getId()));
            return gr;
        }
        this.logger.debug((Object)"could not find group with name");
        return null;
    }

    private void addGroup(String name) {
        if (name.isEmpty()) {
            return;
        }
        this.logger.debug((Object)("adding group: " + name));
        ScimGroup g = new ScimGroup(name);
        try {
            this.scimGroupProvisioning.create(g);
        }
        catch (ScimResourceAlreadyExistsException ex) {
            this.logger.debug((Object)("group " + g + " already exists, ignoring..."));
        }
    }
}

