/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.bootstrap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.manager.NewUserAuthenticatedEvent;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.MemberAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.exception.MemberNotFoundException;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationListener;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ScimUserBootstrap
implements InitializingBean,
ApplicationListener<NewUserAuthenticatedEvent> {
    private static final Log logger = LogFactory.getLog(ScimUserBootstrap.class);
    private final ScimUserProvisioning scimUserProvisioning;
    private final ScimGroupProvisioning scimGroupProvisioning;
    private final ScimGroupMembershipManager membershipManager;
    private boolean override = false;
    private final Collection<UaaUser> users;

    public void setOverride(boolean override) {
        this.override = override;
    }

    public ScimUserBootstrap(ScimUserProvisioning scimUserProvisioning, ScimGroupProvisioning scimGroupProvisioning, ScimGroupMembershipManager membershipManager, Collection<UaaUser> users) {
        Assert.notNull((Object)scimUserProvisioning, (String)"scimUserProvisioning cannot be null");
        Assert.notNull((Object)scimGroupProvisioning, (String)"scimGroupProvisioning cannont be null");
        Assert.notNull((Object)membershipManager, (String)"memberShipManager cannot be null");
        Assert.notNull(users, (String)"users list cannot be null");
        this.scimUserProvisioning = scimUserProvisioning;
        this.scimGroupProvisioning = scimGroupProvisioning;
        this.membershipManager = membershipManager;
        this.users = Collections.unmodifiableCollection(users);
    }

    public void afterPropertiesSet() throws Exception {
        for (UaaUser u : this.users) {
            this.addUser(u);
        }
    }

    private void addUser(UaaUser user) {
        List users = this.scimUserProvisioning.query("userName eq '" + user.getUsername() + "'");
        if (users.isEmpty()) {
            this.createNewUser(user);
        } else if (this.override) {
            this.updateUser((ScimUser)users.get(0), user);
        } else {
            logger.debug((Object)("Override flag not set. Not registering existing user: " + user));
        }
    }

    private void updateUser(ScimUser existingUser, UaaUser updatedUser) {
        String id = existingUser.getId();
        logger.info((Object)("Updating user account: " + updatedUser + " with SCIM Id: " + id));
        logger.info((Object)"Removing existing group memberships ...");
        Set<ScimGroup> existingGroups = this.membershipManager.getGroupsWithMember(id, true);
        for (ScimGroup g : existingGroups) {
            this.removeFromGroup(id, g.getDisplayName());
        }
        ScimUser newScimUser = this.convertToScimUser(updatedUser);
        newScimUser.setVersion(existingUser.getVersion());
        this.scimUserProvisioning.update(id, newScimUser);
        Collection<String> newGroups = this.convertToGroups(updatedUser.getAuthorities());
        logger.info((Object)("Adding new groups " + newGroups));
        this.addGroups(id, newGroups);
        this.scimUserProvisioning.changePassword(id, null, updatedUser.getPassword());
    }

    private void createNewUser(UaaUser user) {
        logger.info((Object)("Registering new user account: " + user));
        ScimUser newScimUser = this.scimUserProvisioning.createUser(this.convertToScimUser(user), user.getPassword());
        this.addGroups(newScimUser.getId(), this.convertToGroups(user.getAuthorities()));
    }

    private void addGroups(String scimUserid, Collection<String> groups) {
        for (String group : groups) {
            this.addToGroup(scimUserid, group);
        }
    }

    public void onApplicationEvent(NewUserAuthenticatedEvent event) {
        this.addUser(event.getUser());
    }

    private void addToGroup(String scimUserId, String gName) {
        ScimGroup group;
        if (!StringUtils.hasText((String)gName)) {
            return;
        }
        logger.debug((Object)("Adding to group: " + gName));
        List g = this.scimGroupProvisioning.query(String.format("displayName eq '%s'", gName));
        if (g == null || g.isEmpty()) {
            group = new ScimGroup(gName);
            group = (ScimGroup)this.scimGroupProvisioning.create(group);
        } else {
            group = (ScimGroup)g.get(0);
        }
        try {
            this.membershipManager.addMember(group.getId(), new ScimGroupMember(scimUserId));
        }
        catch (MemberAlreadyExistsException memberAlreadyExistsException) {
            // empty catch block
        }
    }

    private void removeFromGroup(String scimUserId, String gName) {
        if (!StringUtils.hasText((String)gName)) {
            return;
        }
        logger.debug((Object)("Removing membership of group: " + gName));
        List g = this.scimGroupProvisioning.query(String.format("displayName eq '%s'", gName));
        if (g == null || g.isEmpty()) {
            return;
        }
        ScimGroup group = (ScimGroup)g.get(0);
        try {
            this.membershipManager.removeMemberById(group.getId(), scimUserId);
        }
        catch (MemberNotFoundException memberNotFoundException) {
            // empty catch block
        }
    }

    private ScimUser convertToScimUser(UaaUser user) {
        ScimUser scim = new ScimUser(user.getId(), user.getUsername(), user.getGivenName(), user.getFamilyName());
        scim.addEmail(user.getEmail());
        return scim;
    }

    private Collection<String> convertToGroups(List<? extends GrantedAuthority> authorities) {
        ArrayList<String> groups = new ArrayList<String>();
        for (GrantedAuthority grantedAuthority : authorities) {
            groups.add(grantedAuthority.toString());
        }
        return groups;
    }
}

