/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.endpoints;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.cloudfoundry.identity.uaa.scim.ScimCore;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.mvc.annotation.AnnotationMethodHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;

public class HandlerAdapterFactoryBean
implements FactoryBean<HandlerAdapter>,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public HandlerAdapter getObject() throws Exception {
        RequestMappingHandlerAdapter adapter = new RequestMappingHandlerAdapter();
        adapter.setApplicationContext(this.applicationContext);
        adapter.setMessageConverters(this.getMessageConverters());
        adapter.setOrder(0);
        adapter.setReturnValueHandlers(Arrays.asList(new HandlerMethodReturnValueHandler[]{new ScimEtagHandlerMethodReturnValueHandler(this.getMessageConverters())}));
        adapter.afterPropertiesSet();
        return adapter;
    }

    private List<HttpMessageConverter<?>> getMessageConverters() {
        return new RestTemplate().getMessageConverters();
    }

    public Class<?> getObjectType() {
        return AnnotationMethodHandlerAdapter.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private static class ScimEtagHandlerMethodReturnValueHandler
    extends RequestResponseBodyMethodProcessor {
        public ScimEtagHandlerMethodReturnValueHandler(List<HttpMessageConverter<?>> messageConverters) {
            super(messageConverters);
        }

        public boolean supportsReturnType(MethodParameter returnType) {
            return ScimCore.class.isAssignableFrom(returnType.getMethod().getReturnType());
        }

        public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws IOException, HttpMediaTypeNotAcceptableException {
            if (returnValue instanceof ScimCore) {
                HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
                response.addHeader("ETag", "\"" + ((ScimCore)returnValue).getVersion() + "\"");
            }
            super.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
        }
    }
}

