/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.endpoints;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.rest.SearchResults;
import org.cloudfoundry.identity.uaa.scim.endpoints.ScimUserEndpoints;
import org.cloudfoundry.identity.uaa.scim.exception.ScimException;
import org.cloudfoundry.identity.uaa.security.DefaultSecurityContextAccessor;
import org.cloudfoundry.identity.uaa.security.SecurityContextAccessor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.View;

@Controller
public class UserIdConversionEndpoints
implements InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private SecurityContextAccessor securityContextAccessor = new DefaultSecurityContextAccessor();
    private ScimUserEndpoints scimUserEndpoints;
    private boolean enabled = true;
    private Set<Pattern> patterns = new HashSet<Pattern>();

    public UserIdConversionEndpoints() {
        this.patterns.add(Pattern.compile("(.*?)([a-z0-9]*) eq (.*?)([\\s]*.*)", 2));
        this.patterns.add(Pattern.compile("(.*?)([a-z0-9]*) co (.*?)([\\s]*.*)", 2));
        this.patterns.add(Pattern.compile("(.*?)([a-z0-9]*) sw (.*?)([\\s]*.*)", 2));
        this.patterns.add(Pattern.compile("(.*?)([a-z0-9]*) gt (.*?)([\\s]*.*)", 2));
        this.patterns.add(Pattern.compile("(.*?)([a-z0-9]*) ge (.*?)([\\s]*.*)", 2));
        this.patterns.add(Pattern.compile("(.*?)([a-z0-9]*) lt (.*?)([\\s]*.*)", 2));
        this.patterns.add(Pattern.compile("(.*?)([a-z0-9]*) le (.*?)([\\s]*.*)", 2));
        this.patterns.add(Pattern.compile("pr (.*?)([a-z0-9]*)([\\s]*.*)", 2));
    }

    void setSecurityContextAccessor(SecurityContextAccessor securityContextAccessor) {
        this.securityContextAccessor = securityContextAccessor;
    }

    public void setScimUserEndpoints(ScimUserEndpoints scimUserEndpoints) {
        this.scimUserEndpoints = scimUserEndpoints;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @RequestMapping(value={"/ids/Users"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResults<?> findUsers(@RequestParam(required=true, defaultValue="") String filter, @RequestParam(required=false, defaultValue="ascending") String sortOrder, @RequestParam(required=false, defaultValue="1") int startIndex, @RequestParam(required=false, defaultValue="100") int count) {
        if (!this.enabled) {
            this.logger.warn((Object)("Request from user " + this.securityContextAccessor.getAuthenticationInfo() + " received at disabled Id translation endpoint with filter:" + filter));
            throw new UnsupportedOperationException();
        }
        filter = filter.trim();
        this.checkFilter(filter);
        return this.scimUserEndpoints.findUsers("id,userName", filter, "userName", sortOrder, startIndex, count);
    }

    @ExceptionHandler
    public View handleException(Exception t, HttpServletRequest request) throws ScimException {
        return this.scimUserEndpoints.handleException(t, request);
    }

    @ExceptionHandler(value={UnsupportedOperationException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public void handleException() {
    }

    private void checkFilter(String filter) {
        if (filter.isEmpty()) {
            throw new ScimException("a 'filter' parameter is required", HttpStatus.BAD_REQUEST);
        }
        String lowerCase = filter.toLowerCase();
        if (lowerCase.contains("groups.")) {
            throw new ScimException("Invalid filter expression: [" + filter + "] (no group filters allowed on /ids/Users)", HttpStatus.BAD_REQUEST);
        }
        for (Pattern pattern : this.patterns) {
            String field;
            Matcher matcher = pattern.matcher(lowerCase);
            if (!matcher.matches() || "username".equals(field = matcher.group(2)) || "id".equals(field)) continue;
            throw new ScimException("Invalid filter expression: [" + filter + "] (no " + field + " filters allowed on /ids/Users)", HttpStatus.BAD_REQUEST);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.scimUserEndpoints, (String)"ScimUserEndpoints must be set");
    }
}

