/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.endpoints;

import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class UserIdInjector
implements MethodInterceptor,
InitializingBean {
    private ScimUserProvisioning scimUserProvisioning;
    private int inputIndex = 0;
    private Mode mode = Mode.ID_TO_NAME;
    boolean lookup = false;

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.scimUserProvisioning != null ? 1 : 0) != 0, (String)"ScimUserProvisioning must be provided");
    }

    public void setInputIndex(int inputIndex) {
        this.inputIndex = inputIndex;
    }

    public void setScimUserProvisioning(ScimUserProvisioning scimUserProvisioning) {
        this.scimUserProvisioning = scimUserProvisioning;
    }

    public void setLookup(boolean lookup) {
        this.lookup = lookup;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] args = invocation.getArguments();
        if (!this.lookup || !(args[this.inputIndex] instanceof String)) {
            return invocation.proceed();
        }
        String result = (String)args[this.inputIndex];
        result = this.mode == Mode.NAME_TO_ID ? this.getUserId(result) : this.getUserName(result);
        args[this.inputIndex] = result;
        return invocation.proceed();
    }

    private String getUserName(String userId) {
        String userName = userId;
        try {
            ScimUser scimUser = (ScimUser)this.scimUserProvisioning.retrieve(userName);
            if (scimUser != null) {
                userName = scimUser.getUserName();
            }
        }
        catch (ScimResourceNotFoundException scimResourceNotFoundException) {
            // empty catch block
        }
        return userName;
    }

    private String getUserId(String userName) {
        String userId = userName;
        List users = this.scimUserProvisioning.query("userName eq '" + userName + "'");
        if (!users.isEmpty()) {
            userId = ((ScimUser)users.get(0)).getId();
        }
        return userId;
    }

    public static enum Mode {
        ID_TO_NAME,
        NAME_TO_ID;

    }
}

