/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.rest.jdbc.AbstractQueryable;
import org.cloudfoundry.identity.uaa.rest.jdbc.JdbcPagingListFactory;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.MemberAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.exception.MemberNotFoundException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.scim.jdbc.ScimSearchQueryConverter;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

public class JdbcScimGroupExternalMembershipManager
extends AbstractQueryable<ScimGroupExternalMember>
implements ScimGroupExternalMembershipManager {
    private JdbcTemplate jdbcTemplate;
    private final Log logger = LogFactory.getLog(this.getClass());
    public static final String EXTERNAL_GROUP_MAPPING_FIELDS = "group_id,external_group,added";
    public static final String EXTERNAL_GROUP_MAPPING_TABLE = "external_group_mapping";
    public static final String ADD_EXTERNAL_GROUP_MAPPING_SQL = String.format("insert into %s ( %s ) values (?,?,?)", "external_group_mapping", "group_id,external_group,added");
    public static final String UPDATE_EXTERNAL_GROUP_MAPPING_SQL = String.format("update %s set external_group=? where group_id=?", "external_group_mapping");
    public static final String GET_EXTERNAL_GROUP_MAP_SQL = String.format("select %s from %s", "group_id,external_group,added", "external_group_mapping");
    public static final String GET_EXTERNAL_GROUP_MAPPINGS_SQL = String.format("select %s from %s where group_id=?", "group_id,external_group,added", "external_group_mapping");
    public static final String GET_GROUPS_BY_EXTERNAL_GROUP_MAPPING_SQL = String.format("select %s from %s where lower(external_group)=lower(?)", "group_id,external_group,added", "external_group_mapping");
    public static final String GET_GROUPS_WITH_EXTERNAL_GROUP_MAPPINGS_SQL = String.format("select %s from %s where group_id=? and lower(external_group) like lower(?)", "group_id,external_group,added", "external_group_mapping");
    public static final String DELETE_EXTERNAL_GROUP_MAPPING_SQL = String.format("delete from %s where group_id=? and lower(external_group)=lower(?)", "external_group_mapping");
    public static final String DELETE_EXTERNAL_GROUP_MAPPINGS_USING_GROUP_SQL = String.format("delete from %s where group_id=?", "external_group_mapping");
    public static final String DELETE_EXTERNAL_GROUP_MAPPING_USING_EXTERNAL_GROUPS_SQL = String.format("delete from %s where lower(external_group)=lower(?)", "external_group_mapping");
    private final RowMapper<ScimGroupExternalMember> rowMapper = new ScimGroupExternalMemberRowMapper();
    private ScimGroupProvisioning scimGroupProvisioning;

    public JdbcScimGroupExternalMembershipManager(JdbcTemplate jdbcTemplate, JdbcPagingListFactory pagingListFactory) {
        super(jdbcTemplate, pagingListFactory, (RowMapper)new ScimGroupExternalMemberRowMapper());
        Assert.notNull((Object)jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
        this.setQueryConverter(new ScimSearchQueryConverter());
    }

    @Override
    public ScimGroupExternalMember mapExternalGroup(final String groupId, final String externalGroup) throws ScimResourceNotFoundException, MemberAlreadyExistsException {
        ScimGroup group = (ScimGroup)this.scimGroupProvisioning.retrieve(groupId);
        if (null != group) {
            try {
                this.jdbcTemplate.update(ADD_EXTERNAL_GROUP_MAPPING_SQL, new PreparedStatementSetter(){

                    public void setValues(PreparedStatement ps) throws SQLException {
                        ps.setString(1, groupId);
                        ps.setString(2, externalGroup);
                        ps.setTimestamp(3, new Timestamp(new Date().getTime()));
                    }
                });
            }
            catch (DuplicateKeyException e) {
                throw new MemberAlreadyExistsException("The mapping between group " + group.getDisplayName() + " and external group " + externalGroup + " already exists");
            }
            return this.getExternalGroupMap(groupId, externalGroup);
        }
        return null;
    }

    @Override
    public List<ScimGroupExternalMember> getExternalGroupMapsByGroupId(final String groupId) throws ScimResourceNotFoundException {
        return this.jdbcTemplate.query(GET_EXTERNAL_GROUP_MAPPINGS_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, groupId);
            }
        }, this.rowMapper);
    }

    @Override
    public List<ScimGroupExternalMember> getExternalGroupMapsByGroupName(String groupName) throws ScimResourceNotFoundException {
        final List groups = this.scimGroupProvisioning.query(String.format("displayName eq '%s'", groupName));
        if (null != groups && groups.size() > 0) {
            return this.jdbcTemplate.query(GET_EXTERNAL_GROUP_MAPPINGS_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, ((ScimGroup)groups.get(0)).getId());
                }
            }, this.rowMapper);
        }
        return null;
    }

    @Override
    public List<ScimGroupExternalMember> getExternalGroupMapsByExternalGroup(final String externalGroup) throws ScimResourceNotFoundException {
        return this.jdbcTemplate.query(GET_GROUPS_BY_EXTERNAL_GROUP_MAPPING_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, externalGroup);
            }
        }, this.rowMapper);
    }

    private ScimGroupExternalMember getExternalGroupMap(String groupId, String externalGroup) throws ScimResourceNotFoundException {
        try {
            ScimGroupExternalMember u = (ScimGroupExternalMember)this.jdbcTemplate.queryForObject(GET_GROUPS_WITH_EXTERNAL_GROUP_MAPPINGS_SQL, this.rowMapper, new Object[]{groupId, externalGroup});
            return u;
        }
        catch (EmptyResultDataAccessException e) {
            throw new MemberNotFoundException("The mapping between groupId " + groupId + " and external group " + externalGroup + " does not exist");
        }
    }

    public void setScimGroupProvisioning(ScimGroupProvisioning scimGroupProvisioning) {
        this.scimGroupProvisioning = scimGroupProvisioning;
    }

    protected String getBaseSqlQuery() {
        return GET_EXTERNAL_GROUP_MAP_SQL;
    }

    private static final class ScimGroupExternalMemberRowMapper
    implements RowMapper<ScimGroupExternalMember> {
        private ScimGroupExternalMemberRowMapper() {
        }

        public ScimGroupExternalMember mapRow(ResultSet rs, int rowNum) throws SQLException {
            String groupId = rs.getString(1);
            String externalGroup = rs.getString(2);
            return new ScimGroupExternalMember(groupId, externalGroup);
        }
    }
}

