/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidScimResourceException;
import org.cloudfoundry.identity.uaa.scim.exception.MemberAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.exception.MemberNotFoundException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcScimGroupMembershipManager
implements ScimGroupMembershipManager {
    private JdbcTemplate jdbcTemplate;
    private final Log logger = LogFactory.getLog(this.getClass());
    public static final String MEMBERSHIP_FIELDS = "group_id,member_id,member_type,authorities,added";
    public static final String MEMBERSHIP_TABLE = "group_membership";
    public static final String ADD_MEMBER_SQL = String.format("insert into %s ( %s ) values (?,?,?,?,?)", "group_membership", "group_id,member_id,member_type,authorities,added");
    public static final String UPDATE_MEMBER_SQL = String.format("update %s set authorities=? where group_id=? and member_id=?", "group_membership");
    public static final String GET_MEMBERS_SQL = String.format("select %s from %s where group_id=?", "group_id,member_id,member_type,authorities,added", "group_membership");
    public static final String GET_GROUPS_BY_MEMBER_SQL = String.format("select distinct(group_id) from %s where member_id=?", "group_membership");
    public static final String GET_MEMBERS_WITH_AUTHORITY_SQL = String.format("select %s from %s where group_id=? and lower(authorities) like ?", "group_id,member_id,member_type,authorities,added", "group_membership");
    public static final String GET_MEMBER_SQl = String.format("select %s from %s where group_id=? and member_id=?", "group_id,member_id,member_type,authorities,added", "group_membership");
    public static final String DELETE_MEMBER_SQL = String.format("delete from %s where group_id=? and member_id=?", "group_membership");
    public static final String DELETE_MEMBERS_IN_GROUP_SQL = String.format("delete from %s where group_id=?", "group_membership");
    public static final String DELETE_MEMBER_IN_GROUPS_SQL = String.format("delete from %s where member_id=?", "group_membership");
    private final RowMapper<ScimGroupMember> rowMapper = new ScimGroupMemberRowMapper();
    private ScimUserProvisioning userProvisioning;
    private ScimGroupProvisioning groupProvisioning;
    private Set<ScimGroup> defaultUserGroups = new HashSet<ScimGroup>();

    public void setDefaultUserGroups(Set<String> groupNames) {
        for (String name : groupNames) {
            List g = this.groupProvisioning.query(String.format("displayName co '%s'", name));
            if (!g.isEmpty()) {
                this.defaultUserGroups.add((ScimGroup)g.get(0));
                continue;
            }
            this.defaultUserGroups.add((ScimGroup)this.groupProvisioning.create(new ScimGroup(name)));
        }
    }

    public void setScimUserProvisioning(ScimUserProvisioning userProvisioning) {
        this.userProvisioning = userProvisioning;
    }

    public void setScimGroupProvisioning(ScimGroupProvisioning groupProvisioning) {
        this.groupProvisioning = groupProvisioning;
    }

    public JdbcScimGroupMembershipManager(JdbcTemplate jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public ScimGroupMember addMember(final String groupId, final ScimGroupMember member) throws ScimResourceNotFoundException, MemberAlreadyExistsException {
        this.validateRequest(groupId, member);
        final String authorities = this.getGroupAuthorities(member);
        final String type = (member.getType() == null ? ScimGroupMember.Type.USER : member.getType()).toString();
        try {
            this.jdbcTemplate.update(ADD_MEMBER_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, groupId);
                    ps.setString(2, member.getMemberId());
                    ps.setString(3, type);
                    ps.setString(4, authorities);
                    ps.setTimestamp(5, new Timestamp(new Date().getTime()));
                }
            });
        }
        catch (DuplicateKeyException e) {
            throw new MemberAlreadyExistsException(String.valueOf(member.getMemberId()) + " is already part of the group: " + groupId);
        }
        return this.getMemberById(groupId, member.getMemberId());
    }

    @Override
    public List<ScimGroupMember> getMembers(final String groupId) throws ScimResourceNotFoundException {
        return this.jdbcTemplate.query(GET_MEMBERS_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, groupId);
            }
        }, this.rowMapper);
    }

    @Override
    public Set<ScimGroup> getGroupsWithMember(String memberId, boolean transitive) throws ScimResourceNotFoundException {
        ArrayList<ScimGroup> results = new ArrayList<ScimGroup>();
        this.getGroupsWithMember(results, memberId, transitive);
        if (this.isUser(memberId)) {
            results.addAll(this.defaultUserGroups);
        }
        return new HashSet<ScimGroup>(results);
    }

    private void getGroupsWithMember(List<ScimGroup> results, final String memberId, boolean transitive) {
        List groupIds;
        if (results == null) {
            return;
        }
        try {
            groupIds = this.jdbcTemplate.query(GET_GROUPS_BY_MEMBER_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, memberId);
                }
            }, (RowMapper)new SingleColumnRowMapper(String.class));
        }
        catch (EmptyResultDataAccessException ex) {
            groupIds = Collections.emptyList();
        }
        for (String groupId : groupIds) {
            ScimGroup group;
            try {
                group = (ScimGroup)this.groupProvisioning.retrieve(groupId);
            }
            catch (ScimResourceNotFoundException ex) {
                continue;
            }
            if (results.contains(group)) continue;
            results.add(group);
            if (!transitive) continue;
            this.getGroupsWithMember(results, groupId, transitive);
        }
    }

    @Override
    public List<ScimGroupMember> getMembers(final String groupId, final ScimGroupMember.Role permission) throws ScimResourceNotFoundException {
        this.logger.debug((Object)("getting members of type: " + (Object)((Object)permission) + " from group: " + groupId));
        ArrayList<ScimGroupMember> members = new ArrayList<ScimGroupMember>();
        members.addAll(this.jdbcTemplate.query(GET_MEMBERS_WITH_AUTHORITY_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, groupId);
                ps.setString(2, "%" + permission.toString().toLowerCase() + "%");
            }
        }, this.rowMapper));
        return members;
    }

    @Override
    public ScimGroupMember getMemberById(String groupId, String memberId) throws ScimResourceNotFoundException, MemberNotFoundException {
        try {
            ScimGroupMember u = (ScimGroupMember)this.jdbcTemplate.queryForObject(GET_MEMBER_SQl, this.rowMapper, new Object[]{groupId, memberId});
            return u;
        }
        catch (EmptyResultDataAccessException e) {
            throw new MemberNotFoundException("Member " + memberId + " does not exist in group " + groupId);
        }
    }

    @Override
    public ScimGroupMember updateMember(final String groupId, final ScimGroupMember member) throws ScimResourceNotFoundException, MemberNotFoundException {
        this.validateRequest(groupId, member);
        final String authorities = this.getGroupAuthorities(member);
        int updated = this.jdbcTemplate.update(UPDATE_MEMBER_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, authorities);
                ps.setString(2, groupId);
                ps.setString(3, member.getMemberId());
            }
        });
        if (updated != 1) {
            throw new IncorrectResultSizeDataAccessException("unexpected number of members updated", 1, updated);
        }
        return this.getMemberById(groupId, member.getMemberId());
    }

    @Override
    public List<ScimGroupMember> updateOrAddMembers(String groupId, List<ScimGroupMember> members) throws ScimResourceNotFoundException {
        List<ScimGroupMember> currentMembers = this.getMembers(groupId);
        this.logger.debug((Object)("current-members: " + currentMembers + ", in request: " + members));
        ArrayList<ScimGroupMember> currentMembersToRemove = new ArrayList<ScimGroupMember>(currentMembers);
        currentMembersToRemove.removeAll(members);
        this.logger.debug((Object)("removing members: " + currentMembersToRemove));
        for (ScimGroupMember member : currentMembersToRemove) {
            this.removeMemberById(groupId, member.getMemberId());
        }
        ArrayList<ScimGroupMember> newMembersToAdd = new ArrayList<ScimGroupMember>(members);
        newMembersToAdd.removeAll(currentMembers);
        this.logger.debug((Object)("adding new members: " + newMembersToAdd));
        for (ScimGroupMember member : newMembersToAdd) {
            this.addMember(groupId, member);
        }
        ArrayList<ScimGroupMember> membersToUpdate = new ArrayList<ScimGroupMember>(members);
        membersToUpdate.retainAll(currentMembers);
        this.logger.debug((Object)("updating members: " + membersToUpdate));
        for (ScimGroupMember member : membersToUpdate) {
            this.updateMember(groupId, member);
        }
        return this.getMembers(groupId);
    }

    @Override
    public ScimGroupMember removeMemberById(final String groupId, final String memberId) throws ScimResourceNotFoundException, MemberNotFoundException {
        ScimGroupMember member = this.getMemberById(groupId, memberId);
        int deleted = this.jdbcTemplate.update(DELETE_MEMBER_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, groupId);
                ps.setString(2, memberId);
            }
        });
        if (deleted != 1) {
            throw new IncorrectResultSizeDataAccessException("unexpected number of members removed", 1, deleted);
        }
        return member;
    }

    @Override
    public List<ScimGroupMember> removeMembersByGroupId(final String groupId) throws ScimResourceNotFoundException {
        List<ScimGroupMember> members = this.getMembers(groupId);
        this.logger.debug((Object)("removing " + members + " members from group: " + groupId));
        int deleted = this.jdbcTemplate.update(DELETE_MEMBERS_IN_GROUP_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, groupId);
            }
        });
        if (deleted != members.size()) {
            throw new IncorrectResultSizeDataAccessException("unexpected number of members removed", members.size(), deleted);
        }
        return members;
    }

    @Override
    public Set<ScimGroup> removeMembersByMemberId(final String memberId) throws ScimResourceNotFoundException {
        int expectedDelete;
        Set<ScimGroup> groups = this.getGroupsWithMember(memberId, false);
        this.logger.debug((Object)("removing " + memberId + " from groups: " + groups));
        int deleted = this.jdbcTemplate.update(DELETE_MEMBER_IN_GROUPS_SQL, new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, memberId);
            }
        });
        int n = expectedDelete = this.isUser(memberId) ? groups.size() - this.defaultUserGroups.size() : groups.size();
        if (deleted != expectedDelete) {
            throw new IncorrectResultSizeDataAccessException("unexpected number of members removed", expectedDelete, deleted);
        }
        return groups;
    }

    private boolean isUser(String uuid) {
        try {
            this.userProvisioning.retrieve(uuid);
            return true;
        }
        catch (ScimResourceNotFoundException ex) {
            return false;
        }
    }

    private void validateRequest(String groupId, ScimGroupMember member) {
        if (!StringUtils.hasText((String)groupId) || !StringUtils.hasText((String)member.getMemberId())) {
            throw new InvalidScimResourceException("group-id, member-id and member-type must be non-empty");
        }
        if (groupId.equals(member.getMemberId())) {
            throw new InvalidScimResourceException("trying to nest group within itself, aborting");
        }
        this.groupProvisioning.retrieve(groupId);
        if (member.getType() == ScimGroupMember.Type.GROUP) {
            this.groupProvisioning.retrieve(member.getMemberId());
        } else {
            this.userProvisioning.retrieve(member.getMemberId());
        }
    }

    private String getGroupAuthorities(ScimGroupMember member) {
        if (member.getRoles() != null && !member.getRoles().isEmpty()) {
            return StringUtils.collectionToCommaDelimitedString(member.getRoles());
        }
        return StringUtils.collectionToCommaDelimitedString(ScimGroupMember.GROUP_MEMBER);
    }

    private static final class ScimGroupMemberRowMapper
    implements RowMapper<ScimGroupMember> {
        private ScimGroupMemberRowMapper() {
        }

        public ScimGroupMember mapRow(ResultSet rs, int rowNum) throws SQLException {
            String memberId = rs.getString(2);
            String memberType = rs.getString(3);
            String authorities = rs.getString(4);
            return new ScimGroupMember(memberId, ScimGroupMember.Type.valueOf(memberType), this.getAuthorities(authorities));
        }

        private List<ScimGroupMember.Role> getAuthorities(String authorities) {
            ArrayList<ScimGroupMember.Role> result = new ArrayList<ScimGroupMember.Role>();
            String[] stringArray = authorities.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String a = stringArray[n2];
                if ("read".equalsIgnoreCase(a)) {
                    a = "reader";
                } else if ("write".equalsIgnoreCase(a)) {
                    a = "writer";
                }
                result.add(ScimGroupMember.Role.valueOf(a.toUpperCase()));
                ++n2;
            }
            return result;
        }
    }
}

