/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.jdbc;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cloudfoundry.identity.uaa.rest.AttributeNameMapper;
import org.cloudfoundry.identity.uaa.rest.SimpleAttributeNameMapper;
import org.cloudfoundry.identity.uaa.rest.jdbc.SearchQueryConverter;
import org.springframework.util.StringUtils;

public class ScimSearchQueryConverter
implements SearchQueryConverter {
    static final Pattern coPattern = Pattern.compile("(.*?)([a-z0-9_]*) co '(.*?)'([\\s]*.*)", 2);
    static final Pattern swPattern = Pattern.compile("(.*?)([a-z0-9_]*) sw '(.*?)'([\\s]*.*)", 2);
    static final Pattern eqPattern = Pattern.compile("(.*?)([a-z0-9_]*) eq '(.*?)'([\\s]*.*)", 2);
    static final Pattern boPattern = Pattern.compile("(.*?)([a-z0-9_]*) eq (true|false)([\\s]*.*)", 2);
    static final Pattern metaPattern = Pattern.compile("(.*?)meta\\.([a-z0-9_]*) (\\S) '(.*?)'([\\s]*.*)", 2);
    static final Pattern prPattern = Pattern.compile(" pr([\\s]*)", 2);
    static final Pattern gtPattern = Pattern.compile(" gt ", 2);
    static final Pattern gePattern = Pattern.compile(" ge ", 2);
    static final Pattern ltPattern = Pattern.compile(" lt ", 2);
    static final Pattern lePattern = Pattern.compile(" le ", 2);
    private static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private AttributeNameMapper mapper = new SimpleAttributeNameMapper(Collections.emptyMap());

    public void setAttributeNameMapper(AttributeNameMapper mapper) {
        this.mapper = mapper;
    }

    public SearchQueryConverter.ProcessedFilter convert(String filter, String sortBy, boolean ascending) {
        return this.convert(filter, sortBy, ascending, this.mapper);
    }

    public SearchQueryConverter.ProcessedFilter convert(String filter, String sortBy, boolean ascending, AttributeNameMapper mapper) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        String where = StringUtils.hasText((String)filter) ? this.getWhereClause(filter, sortBy, ascending, values, mapper) : null;
        return new SearchQueryConverter.ProcessedFilter(where, values);
    }

    private String getWhereClause(String filter, String sortBy, boolean ascending, Map<String, Object> values, AttributeNameMapper mapper) {
        String where = filter.replaceAll("\"", "'");
        if (sortBy != null) {
            where = String.valueOf(where) + " order by " + sortBy + (ascending ? " asc" : " desc");
        }
        where = mapper.mapToInternal(where);
        where = this.makeCaseInsensitive(where, coPattern, "%slower(%s) like :?%s", "%%%s%%", values);
        where = this.makeCaseInsensitive(where, swPattern, "%slower(%s) like :?%s", "%s%%", values);
        where = this.makeCaseInsensitive(where, eqPattern, "%slower(%s) = :?%s", "%s", values);
        where = this.makeBooleans(where, boPattern, "%s%s = :?%s", values);
        where = prPattern.matcher(where).replaceAll(" is not null$1");
        where = gtPattern.matcher(where).replaceAll(" > ");
        where = gePattern.matcher(where).replaceAll(" >= ");
        where = ltPattern.matcher(where).replaceAll(" < ");
        where = lePattern.matcher(where).replaceAll(" <= ");
        where = where.replaceAll(" eq ", " = ");
        where = this.makeTimestamps(where, metaPattern, "%s%s %s :?%s", values);
        where = where.replaceAll("meta\\.", "");
        return where;
    }

    private String makeTimestamps(String where, Pattern pattern, String template, Map<String, Object> values) {
        String output = where;
        Matcher matcher = pattern.matcher(output);
        int count = values.size();
        while (matcher.matches()) {
            String property = matcher.group(2);
            Object value = matcher.group(4);
            if (property.equals("created") || property.equals("lastModified")) {
                try {
                    value = TIMESTAMP_FORMAT.parse((String)value);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            values.put("value" + count, value);
            String query = template.replace("?", "value" + count);
            output = matcher.replaceFirst(String.format(query, matcher.group(1), property, matcher.group(3), matcher.group(5)));
            matcher = pattern.matcher(output);
            ++count;
        }
        return output;
    }

    private String makeCaseInsensitive(String where, Pattern pattern, String template, String valueTemplate, Map<String, Object> values) {
        String output = where;
        Matcher matcher = pattern.matcher(output);
        int count = values.size();
        while (matcher.matches()) {
            values.put("value" + count, String.format(valueTemplate, matcher.group(3).toLowerCase()));
            String query = template.replace("?", "value" + count);
            output = matcher.replaceFirst(String.format(query, matcher.group(1), matcher.group(2), matcher.group(4)));
            matcher = pattern.matcher(output);
            ++count;
        }
        return output;
    }

    private String makeBooleans(String where, Pattern pattern, String template, Map<String, Object> values) {
        String output = where;
        Matcher matcher = pattern.matcher(output);
        int count = values.size();
        while (matcher.matches()) {
            values.put("value" + count, Boolean.valueOf(matcher.group(3).toLowerCase()));
            String query = template.replace("?", "value" + count);
            output = matcher.replaceFirst(String.format(query, matcher.group(1), matcher.group(2), matcher.group(4)));
            matcher = pattern.matcher(output);
            ++count;
        }
        return output;
    }
}

