/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.remote;

import java.util.List;
import org.cloudfoundry.identity.uaa.message.PasswordChangeRequest;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidScimResourceException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class RemoteScimUserProvisioning
implements ScimUserProvisioning {
    private RestOperations restTemplate = new RestTemplate();
    private String baseUrl = "https://uaa.cloudfoundry.com";

    public void setRestTemplate(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public ScimUser retrieve(String id) throws ScimResourceNotFoundException {
        return (ScimUser)this.restTemplate.getForObject(String.valueOf(this.baseUrl) + "/User/{id}", ScimUser.class, new Object[]{id});
    }

    public List<ScimUser> retrieveAll() {
        return (List)this.restTemplate.getForObject(String.valueOf(this.baseUrl) + "/Users", List.class, new Object[0]);
    }

    public List<ScimUser> query(String filter) {
        return (List)this.restTemplate.getForObject(String.valueOf(this.baseUrl) + "/Users?filter={filter}", List.class, new Object[]{filter});
    }

    public List<ScimUser> query(String filter, String sortBy, boolean ascending) {
        String order = ascending ? "" : "&sortOrder=descending";
        return (List)this.restTemplate.getForObject(String.valueOf(this.baseUrl) + "/Users?filter={filter}&sortBy={sortBy}" + order, List.class, new Object[]{filter, sortBy});
    }

    public ScimUser create(ScimUser user) {
        return (ScimUser)this.restTemplate.postForObject(String.valueOf(this.baseUrl) + "/User", (Object)user, ScimUser.class, new Object[0]);
    }

    @Override
    public ScimUser createUser(ScimUser user, String password) throws InvalidPasswordException, InvalidScimResourceException {
        user.setPassword(password);
        return this.create(user);
    }

    public ScimUser update(String id, ScimUser user) throws InvalidScimResourceException, ScimResourceNotFoundException {
        this.restTemplate.put(String.valueOf(this.baseUrl) + "/User/{id}", (Object)user, new Object[]{id});
        return user;
    }

    @Override
    public boolean changePassword(String id, String oldPassword, String newPassword) throws ScimResourceNotFoundException {
        PasswordChangeRequest request = new PasswordChangeRequest();
        request.setOldPassword(oldPassword);
        request.setPassword(newPassword);
        this.restTemplate.put(String.valueOf(this.baseUrl) + "/User/{id}/password", (Object)request, new Object[]{id});
        return true;
    }

    public ScimUser delete(String id, int version) throws ScimResourceNotFoundException {
        HttpHeaders headers = new HttpHeaders();
        headers.set("If-Match", String.format("%d", version));
        return (ScimUser)this.restTemplate.exchange(String.valueOf(this.baseUrl) + "/User/{id}", HttpMethod.DELETE, new HttpEntity((MultiValueMap)headers), ScimUser.class, new Object[]{id}).getBody();
    }
}

