/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.endpoints;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.password.event.PasswordChangeEvent;
import org.cloudfoundry.identity.uaa.password.event.PasswordChangeFailureEvent;
import org.cloudfoundry.identity.uaa.password.event.ResetPasswordRequestEvent;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PasswordResetEndpoints
implements ApplicationEventPublisherAware {
    public static final int PASSWORD_RESET_LIFETIME = 1800000;
    private final ScimUserProvisioning scimUserProvisioning;
    private final ExpiringCodeStore expiringCodeStore;
    private final ObjectMapper objectMapper;
    private ApplicationEventPublisher publisher;

    public PasswordResetEndpoints(ObjectMapper objectMapper, ScimUserProvisioning scimUserProvisioning, ExpiringCodeStore expiringCodeStore) {
        this.objectMapper = objectMapper;
        this.scimUserProvisioning = scimUserProvisioning;
        this.expiringCodeStore = expiringCodeStore;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @RequestMapping(value={"/password_resets"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, String>> resetPassword(@RequestBody String email) throws IOException {
        String jsonEmail = this.objectMapper.writeValueAsString((Object)email);
        HashMap<String, String> response = new HashMap<String, String>();
        List results = this.scimUserProvisioning.query("userName eq " + jsonEmail + " and origin eq \"" + "uaa" + "\"");
        if (results.isEmpty()) {
            results = this.scimUserProvisioning.query("userName eq " + jsonEmail);
            if (results.isEmpty()) {
                return new ResponseEntity(HttpStatus.NOT_FOUND);
            }
            response.put("user_id", ((ScimUser)results.get(0)).getId());
            return new ResponseEntity(response, HttpStatus.CONFLICT);
        }
        ScimUser scimUser = (ScimUser)results.get(0);
        String code = this.expiringCodeStore.generateCode(scimUser.getId(), new Timestamp(System.currentTimeMillis() + 1800000L)).getCode();
        this.publish((ApplicationEvent)new ResetPasswordRequestEvent(email, code, SecurityContextHolder.getContext().getAuthentication()));
        response.put("code", code);
        response.put("user_id", scimUser.getId());
        return new ResponseEntity(response, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/password_change"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, String>> changePassword(@RequestBody PasswordChange passwordChange) {
        Object responseEntity = this.isCodeAuthenticatedChange(passwordChange) ? this.changePasswordCodeAuthenticated(passwordChange) : (this.isUsernamePasswordAuthenticatedChange(passwordChange) ? this.changePasswordUsernamePasswordAuthenticated(passwordChange) : new ResponseEntity(HttpStatus.BAD_REQUEST));
        return responseEntity;
    }

    private boolean isUsernamePasswordAuthenticatedChange(PasswordChange passwordChange) {
        return passwordChange.getUsername() != null && passwordChange.getCurrentPassword() != null && passwordChange.getCode() == null;
    }

    private boolean isCodeAuthenticatedChange(PasswordChange passwordChange) {
        return passwordChange.getCode() != null && passwordChange.getCurrentPassword() == null && passwordChange.getUsername() == null;
    }

    private ResponseEntity<Map<String, String>> changePasswordUsernamePasswordAuthenticated(PasswordChange passwordChange) {
        List results = this.scimUserProvisioning.query("userName eq \"" + passwordChange.getUsername() + "\"");
        if (results.isEmpty()) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        String oldPassword = passwordChange.getCurrentPassword();
        ScimUser user = (ScimUser)results.get(0);
        try {
            this.scimUserProvisioning.changePassword(user.getId(), oldPassword, passwordChange.getNewPassword());
            this.publish((ApplicationEvent)new PasswordChangeEvent("Password changed", this.getUaaUser(user), SecurityContextHolder.getContext().getAuthentication()));
            HashMap<String, String> userInfo = new HashMap<String, String>();
            userInfo.put("user_id", user.getId());
            userInfo.put("username", user.getUserName());
            return new ResponseEntity(userInfo, HttpStatus.OK);
        }
        catch (BadCredentialsException x) {
            this.publish((ApplicationEvent)new PasswordChangeFailureEvent(x.getMessage(), this.getUaaUser(user), SecurityContextHolder.getContext().getAuthentication()));
            return new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
        catch (ScimResourceNotFoundException x) {
            this.publish((ApplicationEvent)new PasswordChangeFailureEvent(x.getMessage(), this.getUaaUser(user), SecurityContextHolder.getContext().getAuthentication()));
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (Exception x) {
            this.publish((ApplicationEvent)new PasswordChangeFailureEvent(x.getMessage(), this.getUaaUser(user), SecurityContextHolder.getContext().getAuthentication()));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private ResponseEntity<Map<String, String>> changePasswordCodeAuthenticated(PasswordChange passwordChange) {
        ExpiringCode expiringCode = this.expiringCodeStore.retrieveCode(passwordChange.getCode());
        if (expiringCode == null) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        String userId = expiringCode.getData();
        ScimUser user = (ScimUser)this.scimUserProvisioning.retrieve(userId);
        try {
            if (!user.isVerified()) {
                this.scimUserProvisioning.verifyUser(userId, -1);
            }
            this.scimUserProvisioning.changePassword(userId, null, passwordChange.getNewPassword());
            this.publish((ApplicationEvent)new PasswordChangeEvent("Password changed", this.getUaaUser(user), SecurityContextHolder.getContext().getAuthentication()));
            HashMap<String, String> userInfo = new HashMap<String, String>();
            userInfo.put("user_id", user.getId());
            userInfo.put("username", user.getUserName());
            userInfo.put("email", user.getPrimaryEmail());
            return new ResponseEntity(userInfo, HttpStatus.OK);
        }
        catch (BadCredentialsException x) {
            this.publish((ApplicationEvent)new PasswordChangeFailureEvent(x.getMessage(), this.getUaaUser(user), SecurityContextHolder.getContext().getAuthentication()));
            return new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
        catch (ScimResourceNotFoundException x) {
            this.publish((ApplicationEvent)new PasswordChangeFailureEvent(x.getMessage(), this.getUaaUser(user), SecurityContextHolder.getContext().getAuthentication()));
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (Exception x) {
            this.publish((ApplicationEvent)new PasswordChangeFailureEvent(x.getMessage(), this.getUaaUser(user), SecurityContextHolder.getContext().getAuthentication()));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private UaaUser getUaaUser(ScimUser scimUser) {
        Date today = new Date();
        return new UaaUser(scimUser.getId(), scimUser.getUserName(), "N/A", scimUser.getPrimaryEmail(), null, scimUser.getGivenName(), scimUser.getFamilyName(), today, today, scimUser.getOrigin(), scimUser.getExternalId(), scimUser.isVerified(), scimUser.getZoneId());
    }

    protected void publish(ApplicationEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent(event);
        }
    }

    public static class PasswordChange {
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="code")
        private String code;
        @JsonProperty(value="current_password")
        private String currentPassword;
        @JsonProperty(value="new_password")
        private String newPassword;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getCurrentPassword() {
            return this.currentPassword;
        }

        public void setCurrentPassword(String currentPassword) {
            this.currentPassword = currentPassword;
        }

        public String getNewPassword() {
            return this.newPassword;
        }

        public void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }
    }
}

