/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.validate;

import edu.vt.middleware.dictionary.ArrayWordList;
import edu.vt.middleware.dictionary.Dictionary;
import edu.vt.middleware.dictionary.WordList;
import edu.vt.middleware.dictionary.WordListDictionary;
import edu.vt.middleware.dictionary.WordLists;
import edu.vt.middleware.password.AlphabeticalCharacterRule;
import edu.vt.middleware.password.AlphabeticalSequenceRule;
import edu.vt.middleware.password.DictionarySubstringRule;
import edu.vt.middleware.password.DigitCharacterRule;
import edu.vt.middleware.password.LengthRule;
import edu.vt.middleware.password.NumericalSequenceRule;
import edu.vt.middleware.password.Password;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.QwertySequenceRule;
import edu.vt.middleware.password.RegexRule;
import edu.vt.middleware.password.RepeatCharacterRegexRule;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.UsernameRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.scim.validate.PasswordValidator;
import org.springframework.util.StringUtils;

public class DefaultPasswordValidator
implements PasswordValidator {
    private final List<Rule> defaultRules;
    private final List<Rule> shortRules;

    public DefaultPasswordValidator() {
        ArrayList<Object> rules = new ArrayList<Object>(6);
        rules.add(new LengthRule(10, 50));
        rules.add(new DigitCharacterRule());
        rules.add(new AlphabeticalCharacterRule());
        rules.add(new UsernameRule(true, true));
        rules.add(new RegexRule("[pP]+[aA@&]*[sSzZ$]+[wW]+[oO0]*[rR]*[dD]*"));
        rules.add(new QwertySequenceRule());
        this.defaultRules = Collections.unmodifiableList(rules);
        rules = new ArrayList(3);
        rules.add(new NumericalSequenceRule());
        rules.add(new RepeatCharacterRegexRule());
        rules.add(new AlphabeticalSequenceRule());
        this.shortRules = Collections.unmodifiableList(rules);
    }

    @Override
    public void validate(String password, ScimUser user) throws InvalidPasswordException {
        PasswordData passwordData = new PasswordData(new Password(password));
        passwordData.setUsername(user.getUserName());
        ArrayList<Rule> rules = new ArrayList<Rule>(this.defaultRules);
        if (password.length() < 20) {
            rules.addAll(this.shortRules);
        }
        String[] userWords = user.wordList().toArray(new String[user.wordList().size()]);
        Arrays.sort(userWords, WordLists.CASE_INSENSITIVE_COMPARATOR);
        rules.add((Rule)new DictionarySubstringRule((Dictionary)new WordListDictionary((WordList)new ArrayWordList(userWords, false))));
        edu.vt.middleware.password.PasswordValidator validator = new edu.vt.middleware.password.PasswordValidator(rules);
        RuleResult result = validator.validate(passwordData);
        if (!result.isValid()) {
            String errors = StringUtils.collectionToDelimitedString((Collection)validator.getMessages(result), (String)",");
            throw new InvalidPasswordException(errors);
        }
    }
}

