/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.password;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.error.ConvertingExceptionView;
import org.cloudfoundry.identity.uaa.error.ExceptionReport;
import org.cloudfoundry.identity.uaa.message.PasswordChangeRequest;
import org.cloudfoundry.identity.uaa.message.SimpleMessage;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.security.DefaultSecurityContextAccessor;
import org.cloudfoundry.identity.uaa.security.SecurityContextAccessor;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.View;

@Controller
public class PasswordChangeEndpoint {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ScimUserProvisioning dao;
    private SecurityContextAccessor securityContextAccessor = new DefaultSecurityContextAccessor();
    private HttpMessageConverter<?>[] messageConverters = new RestTemplate().getMessageConverters().toArray(new HttpMessageConverter[0]);

    public void setScimUserProvisioning(ScimUserProvisioning provisioning) {
        this.dao = provisioning;
    }

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        this.messageConverters = messageConverters;
    }

    void setSecurityContextAccessor(SecurityContextAccessor securityContextAccessor) {
        this.securityContextAccessor = securityContextAccessor;
    }

    @RequestMapping(value={"/Users/{userId}/password"}, method={RequestMethod.PUT})
    @ResponseBody
    public SimpleMessage changePassword(@PathVariable String userId, @RequestBody PasswordChangeRequest change) {
        this.checkPasswordChangeIsAllowed(userId, change.getOldPassword());
        this.dao.changePassword(userId, change.getOldPassword(), change.getPassword());
        return new SimpleMessage("ok", "password updated");
    }

    @ExceptionHandler
    public View handleException(ScimResourceNotFoundException e) {
        return new ConvertingExceptionView(new ResponseEntity((Object)new ExceptionReport((Exception)((Object)new BadCredentialsException("Invalid password change request")), false), HttpStatus.UNAUTHORIZED), this.messageConverters);
    }

    @ExceptionHandler
    public View handleException(ScimException e) {
        return new ConvertingExceptionView(new ResponseEntity((Object)new ExceptionReport((Exception)((Object)new BadCredentialsException("Invalid password change request")), false), e.getStatus()), this.messageConverters);
    }

    private void checkPasswordChangeIsAllowed(String userId, String oldPassword) {
        if (this.securityContextAccessor.isClient()) {
            return;
        }
        String currentUser = this.securityContextAccessor.getUserId();
        if (this.securityContextAccessor.isAdmin()) {
            if (userId.equals(currentUser) && !StringUtils.hasText((String)oldPassword)) {
                throw new InvalidPasswordException("Previous password is required even for admin");
            }
        } else {
            if (!userId.equals(currentUser)) {
                this.logger.warn((Object)("User with id " + currentUser + " attempting to change password for user " + userId));
                throw new InvalidPasswordException("Not permitted to change another user's password");
            }
            if (!StringUtils.hasText((String)oldPassword)) {
                throw new InvalidPasswordException("Previous password is required");
            }
        }
    }
}

