/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.password;

import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.endpoints.PasswordScore;
import org.cloudfoundry.identity.uaa.scim.endpoints.PasswordScoreCalculator;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.scim.validate.PasswordValidator;

public class ZxcvbnPasswordValidator
implements PasswordValidator {
    private PasswordScoreCalculator scoreCalculator;

    public void setScoreCalculator(PasswordScoreCalculator scoreCalculator) {
        this.scoreCalculator = scoreCalculator;
    }

    @Override
    public void validate(String password, ScimUser user) {
        PasswordScore score = this.scoreCalculator.computeScore(password, new String[0]);
        if (score.getScore() < score.getRequiredScore()) {
            throw new InvalidPasswordException(String.format("Insufficient password strength: %d", score.getScore()));
        }
    }
}

