/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.security;

import java.util.Collection;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupMembershipManager;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.util.StringUtils;

public class GroupVoter
implements AccessDecisionVoter<Object> {
    private ScimGroupMembershipManager membershipManager;
    private String groupPrefix = "groupScope=";

    public void setGroupPrefix(String groupPrefix) {
        this.groupPrefix = groupPrefix;
    }

    public void setMembershipManager(ScimGroupMembershipManager membershipManager) {
        this.membershipManager = membershipManager;
    }

    public boolean supports(ConfigAttribute attribute) {
        return StringUtils.hasText((String)attribute.getAttribute()) && attribute.getAttribute().startsWith(this.groupPrefix);
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        if (authentication instanceof OAuth2Authentication && ((OAuth2Authentication)authentication).isClientOnly()) {
            return 0;
        }
        String userId = ((UaaPrincipal)authentication.getPrincipal()).getId();
        String groupId = this.getGroupId(((FilterInvocation)object).getRequestUrl());
        for (ConfigAttribute attribute : attributes) {
            if (!this.supports(attribute)) continue;
            String requiredAuthority = attribute.getAttribute().substring(this.groupPrefix.length());
            if (this.membershipManager.getMembers(groupId, ScimGroupMember.Role.valueOf(requiredAuthority.toUpperCase())).contains(new ScimGroupMember(userId))) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    private String getGroupId(String url) {
        int startIndex = url.lastIndexOf("/") + 1;
        int endIndex = url.indexOf("?") > 0 ? url.indexOf("?") : url.length();
        return url.substring(startIndex, endIndex);
    }
}

