/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMember;
import org.cloudfoundry.identity.uaa.scim.ScimGroupExternalMembershipManager;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceAlreadyExistsException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class ScimExternalGroupBootstrap
implements InitializingBean {
    private List<Map<String, String>> externalGroupMap;
    private Set<String> externalGroupList;
    private final ScimGroupProvisioning scimGroupProvisioning;
    private final ScimGroupExternalMembershipManager externalMembershipManager;
    private static final String GROUP_BY_NAME_FILTER = "displayName eq \"%s\"";
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean addNonExistingGroups = false;

    protected ScimGroupProvisioning getScimGroupProvisioning() {
        return this.scimGroupProvisioning;
    }

    public boolean isAddNonExistingGroups() {
        return this.addNonExistingGroups;
    }

    public void setAddNonExistingGroups(boolean addNonExistingGroups) {
        this.addNonExistingGroups = addNonExistingGroups;
    }

    public ScimExternalGroupBootstrap(ScimGroupProvisioning scimGroupProvisioning, ScimGroupExternalMembershipManager externalMembershipManager) {
        this.scimGroupProvisioning = scimGroupProvisioning;
        this.externalMembershipManager = externalMembershipManager;
        this.externalGroupMap = new ArrayList<Map<String, String>>();
    }

    public void setExternalGroupMap(Set<String> externalGroupMaps) {
        this.externalGroupList = externalGroupMaps;
    }

    protected ScimGroup addGroup(String groupName) {
        ScimGroup group = new ScimGroup(groupName);
        try {
            return (ScimGroup)this.getScimGroupProvisioning().create(group);
        }
        catch (ScimResourceAlreadyExistsException x) {
            List groups = this.getScimGroupProvisioning().query(String.format(GROUP_BY_NAME_FILTER, groupName));
            if (groups != null && groups.size() > 0) {
                return (ScimGroup)groups.get(0);
            }
            throw new RuntimeException("Unable to create or return group with name:" + groupName);
        }
    }

    public void afterPropertiesSet() throws Exception {
        for (String string : this.externalGroupList) {
            String[] externalGroups;
            String[] fields = string.split("\\|");
            if (fields.length < 2) continue;
            String groupName = fields[0];
            ArrayList<ScimGroup> groups = this.getScimGroupProvisioning().query(String.format(GROUP_BY_NAME_FILTER, groupName));
            if (groups == null || groups.size() == 0 && this.isAddNonExistingGroups()) {
                groups = new ArrayList<ScimGroup>();
                groups.add(this.addGroup(groupName));
            }
            if (null == groups || groups.size() != 1) continue;
            String groupId = ((ScimGroup)groups.get(0)).getId();
            if (null == fields[1] || fields[1].length() <= 0 || null == (externalGroups = fields[1].split(" ")) || externalGroups.length <= 0) continue;
            for (String externalGroup : externalGroups) {
                if (!StringUtils.hasLength((String)externalGroup.trim())) continue;
                this.externalGroupMap.add(Collections.singletonMap(groupId, externalGroup.trim()));
            }
        }
        for (Map map : this.externalGroupMap) {
            Map.Entry entry = map.entrySet().iterator().next();
            this.addGroupMap((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void addGroupMap(String groupId, String externalGroup) {
        ScimGroupExternalMember externalGroupMapping = this.externalMembershipManager.mapExternalGroup(groupId, externalGroup);
        this.logger.debug((Object)("adding external group mapping: " + externalGroupMapping));
    }
}

