/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.rest.jdbc.AbstractQueryable;
import org.cloudfoundry.identity.uaa.rest.jdbc.JdbcPagingListFactory;
import org.cloudfoundry.identity.uaa.rest.jdbc.SearchQueryConverter;
import org.cloudfoundry.identity.uaa.scim.ScimGroup;
import org.cloudfoundry.identity.uaa.scim.ScimGroupProvisioning;
import org.cloudfoundry.identity.uaa.scim.ScimMeta;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidScimResourceException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceAlreadyExistsException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceConstraintFailedException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.cloudfoundry.identity.uaa.scim.jdbc.ScimSearchQueryConverter;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcScimGroupProvisioning
extends AbstractQueryable<ScimGroup>
implements ScimGroupProvisioning {
    private JdbcTemplate jdbcTemplate;
    private final Log logger = LogFactory.getLog(this.getClass());
    public static final String GROUP_FIELDS = "id,displayName,created,lastModified,version,identity_zone_id";
    public static final String GROUP_TABLE = "groups";
    public static final String ADD_GROUP_SQL = String.format("insert into %s ( %s ) values (?,?,?,?,?,?)", "groups", "id,displayName,created,lastModified,version,identity_zone_id");
    public static final String UPDATE_GROUP_SQL = String.format("update %s set version=?, displayName=?, lastModified=? where id=? and version=?", "groups");
    public static final String GET_GROUPS_SQL = "select %s from %s where identity_zone_id='%s'";
    public static final String GET_GROUP_SQL = String.format("select %s from %s where id=? and identity_zone_id=?", "id,displayName,created,lastModified,version,identity_zone_id", "groups");
    public static final String DELETE_GROUP_SQL = String.format("delete from %s where id=? and identity_zone_id=?", "groups");
    private final RowMapper<ScimGroup> rowMapper = new ScimGroupRowMapper();

    public JdbcScimGroupProvisioning(JdbcTemplate jdbcTemplate, JdbcPagingListFactory pagingListFactory) {
        super(jdbcTemplate, pagingListFactory, (RowMapper)new ScimGroupRowMapper());
        Assert.notNull((Object)jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
        this.setQueryConverter((SearchQueryConverter)new ScimSearchQueryConverter());
    }

    protected String getBaseSqlQuery() {
        return String.format(GET_GROUPS_SQL, GROUP_FIELDS, GROUP_TABLE, IdentityZoneHolder.get().getId());
    }

    protected String getQuerySQL(String filter, SearchQueryConverter.ProcessedFilter where) {
        boolean containsWhereClause = this.getBaseSqlQuery().contains(" where ");
        return filter == null || filter.trim().length() == 0 ? this.getBaseSqlQuery() : this.getBaseSqlQuery() + (containsWhereClause ? " and " : " where ") + where.getSql();
    }

    protected String getTableName() {
        return GROUP_TABLE;
    }

    public List<ScimGroup> retrieveAll() {
        return this.query("id pr", "created", true);
    }

    public ScimGroup retrieve(String id) throws ScimResourceNotFoundException {
        try {
            ScimGroup group = (ScimGroup)this.jdbcTemplate.queryForObject(GET_GROUP_SQL, this.rowMapper, new Object[]{id, IdentityZoneHolder.get().getId()});
            return group;
        }
        catch (EmptyResultDataAccessException e) {
            throw new ScimResourceNotFoundException("Group " + id + " does not exist");
        }
    }

    public ScimGroup create(final ScimGroup group) throws InvalidScimResourceException {
        final String id = UUID.randomUUID().toString();
        this.logger.debug((Object)("creating new group with id: " + id));
        try {
            this.validateGroup(group);
            this.jdbcTemplate.update(ADD_GROUP_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, id);
                    ps.setString(2, group.getDisplayName());
                    ps.setTimestamp(3, new Timestamp(new Date().getTime()));
                    ps.setTimestamp(4, new Timestamp(new Date().getTime()));
                    ps.setInt(5, group.getVersion());
                    ps.setString(6, group.getZoneId());
                }
            });
        }
        catch (DuplicateKeyException ex) {
            throw new ScimResourceAlreadyExistsException("A group with displayName: " + group.getDisplayName() + " already exists.");
        }
        return this.retrieve(id);
    }

    public ScimGroup update(final String id, final ScimGroup group) throws InvalidScimResourceException, ScimResourceNotFoundException {
        try {
            this.validateGroup(group);
            int updated = this.jdbcTemplate.update(UPDATE_GROUP_SQL, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setInt(1, group.getVersion() + 1);
                    ps.setString(2, group.getDisplayName());
                    ps.setTimestamp(3, new Timestamp(new Date().getTime()));
                    ps.setString(4, id);
                    ps.setInt(5, group.getVersion());
                }
            });
            if (updated != 1) {
                throw new IncorrectResultSizeDataAccessException(1, updated);
            }
            return this.retrieve(id);
        }
        catch (DuplicateKeyException ex) {
            throw new InvalidScimResourceException("A group with displayName: " + group.getDisplayName() + " already exists");
        }
    }

    public ScimGroup delete(String id, int version) throws ScimResourceNotFoundException {
        ScimGroup group = this.retrieve(id);
        int deleted = version > 0 ? this.jdbcTemplate.update(DELETE_GROUP_SQL + " and version=?;", new Object[]{id, IdentityZoneHolder.get().getId(), version}) : this.jdbcTemplate.update(DELETE_GROUP_SQL, new Object[]{id, IdentityZoneHolder.get().getId()});
        if (deleted != 1) {
            throw new IncorrectResultSizeDataAccessException(1, deleted);
        }
        return group;
    }

    protected void validateGroup(ScimGroup group) throws ScimResourceConstraintFailedException {
        if (!StringUtils.hasText((String)group.getZoneId())) {
            throw new ScimResourceConstraintFailedException("zoneId is a required field");
        }
    }

    private static final class ScimGroupRowMapper
    implements RowMapper<ScimGroup> {
        private ScimGroupRowMapper() {
        }

        public ScimGroup mapRow(ResultSet rs, int rowNum) throws SQLException {
            String id = rs.getString(1);
            String name = rs.getString(2);
            Timestamp created = rs.getTimestamp(3);
            Timestamp modified = rs.getTimestamp(4);
            int version = rs.getInt(5);
            String zoneId = rs.getString(6);
            ScimGroup group = new ScimGroup(id, name, zoneId);
            ScimMeta meta = new ScimMeta(created, modified, version);
            group.setMeta(meta);
            return group;
        }
    }
}

