/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ScimGroupMember {
    public static final List<Role> GROUP_MEMBER = Arrays.asList(Role.MEMBER);
    public static final List<Role> GROUP_ADMIN = Arrays.asList(Role.READER, Role.WRITER);
    @JsonProperty(value="value")
    private String memberId;
    private String origin = "uaa";
    private Type type;
    @JsonIgnore
    private List<Role> roles;

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(List<Role> permissions) {
        this.roles = permissions;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        return String.format("(memberId: %s, type: %s, roles: %s, origin:%s)", new Object[]{this.getMemberId(), this.getType(), this.getRoles(), this.getOrigin()});
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        if (origin == null) {
            throw new NullPointerException();
        }
        this.origin = origin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimGroupMember member = (ScimGroupMember)o;
        if (this.getMemberId() != null ? !this.getMemberId().equals(member.getMemberId()) : member.getMemberId() != null) {
            return false;
        }
        return this.getType() == member.getType();
    }

    public int hashCode() {
        int result = this.getMemberId() != null ? this.getMemberId().hashCode() : 0;
        result = 31 * result + (this.getOrigin() != null ? this.getOrigin().hashCode() : 0);
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        return result;
    }

    public ScimGroupMember() {
    }

    public ScimGroupMember(String memberId) {
        this(memberId, Type.USER, GROUP_MEMBER);
    }

    public ScimGroupMember(String memberId, Type type, List<Role> roles) {
        this.memberId = memberId;
        this.type = type;
        this.roles = roles;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static enum Type {
        USER,
        GROUP;

    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static enum Role {
        MEMBER,
        READER,
        WRITER;

    }
}

