/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.endpoints;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.identity.uaa.audit.event.UserModifiedEvent;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCode;
import org.cloudfoundry.identity.uaa.codestore.ExpiringCodeStore;
import org.cloudfoundry.identity.uaa.error.UaaException;
import org.cloudfoundry.identity.uaa.rest.QueryableResourceManager;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.util.JsonUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class ChangeEmailEndpoints
implements ApplicationEventPublisherAware {
    private final ScimUserProvisioning scimUserProvisioning;
    private final ExpiringCodeStore expiringCodeStore;
    private ApplicationEventPublisher publisher;
    private final QueryableResourceManager<ClientDetails> clientDetailsService;
    private static final int EMAIL_CHANGE_LIFETIME = 1800000;
    public static final String CHANGE_EMAIL_REDIRECT_URL = "change_email_redirect_url";

    public ChangeEmailEndpoints(ScimUserProvisioning scimUserProvisioning, ExpiringCodeStore expiringCodeStore, QueryableResourceManager<ClientDetails> clientDetailsService) {
        this.scimUserProvisioning = scimUserProvisioning;
        this.expiringCodeStore = expiringCodeStore;
        this.clientDetailsService = clientDetailsService;
    }

    @RequestMapping(value={"/email_verifications"}, method={RequestMethod.POST})
    public ResponseEntity<String> generateEmailVerificationCode(@RequestBody EmailChange emailChange) {
        String code;
        List results;
        String userId = emailChange.getUserId();
        String email = emailChange.getEmail();
        ScimUser user = (ScimUser)this.scimUserProvisioning.retrieve(userId);
        if (user.getUserName().equals(user.getPrimaryEmail()) && !(results = this.scimUserProvisioning.query("userName eq \"" + email + "\" and origin eq \"" + "uaa" + "\"")).isEmpty()) {
            return new ResponseEntity(HttpStatus.CONFLICT);
        }
        try {
            code = this.expiringCodeStore.generateCode(JsonUtils.writeValueAsString((Object)emailChange), new Timestamp(System.currentTimeMillis() + 1800000L)).getCode();
        }
        catch (JsonUtils.JsonUtilException e) {
            throw new UaaException("Error while generating change email code", (Throwable)e);
        }
        return new ResponseEntity((Object)code, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/email_changes"}, method={RequestMethod.POST})
    public ResponseEntity<EmailChangeResponse> changeEmail(@RequestBody String code) throws IOException {
        ExpiringCode expiringCode = this.expiringCodeStore.retrieveCode(code);
        if (expiringCode != null) {
            Map data = (Map)JsonUtils.readValue((String)expiringCode.getData(), (TypeReference)new TypeReference<Map<String, String>>(){});
            String userId = (String)data.get("userId");
            String email = (String)data.get("email");
            ScimUser user = (ScimUser)this.scimUserProvisioning.retrieve(userId);
            if (user.getUserName().equals(user.getPrimaryEmail())) {
                user.setUserName(email);
            }
            user.setPrimaryEmail(email);
            this.scimUserProvisioning.update(userId, user);
            String redirectLocation = null;
            String clientId = (String)data.get("client_id");
            if (clientId != null && !clientId.equals("")) {
                ClientDetails clientDetails = (ClientDetails)this.clientDetailsService.retrieve(clientId);
                redirectLocation = (String)clientDetails.getAdditionalInformation().get(CHANGE_EMAIL_REDIRECT_URL);
            }
            this.publisher.publishEvent((ApplicationEvent)UserModifiedEvent.emailChanged((String)userId, (String)user.getUserName(), (String)user.getPrimaryEmail()));
            EmailChangeResponse emailChangeResponse = new EmailChangeResponse();
            emailChangeResponse.setEmail(email);
            emailChangeResponse.setUserId(userId);
            emailChangeResponse.setUsername(user.getUserName());
            emailChangeResponse.setRedirectUrl(redirectLocation);
            return new ResponseEntity((Object)emailChangeResponse, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public static class EmailChangeResponse {
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="userId")
        private String userId;
        @JsonProperty(value="redirect_url")
        private String redirectUrl;
        @JsonProperty(value="email")
        private String email;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getRedirectUrl() {
            return this.redirectUrl;
        }

        public void setRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
        }
    }

    public static class EmailChange {
        @JsonProperty(value="userId")
        private String userId;
        @JsonProperty(value="email")
        private String email;
        @JsonProperty(value="client_id")
        private String clientId;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }
    }
}

