/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.scim.endpoints;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.identity.uaa.error.ConvertingExceptionView;
import org.cloudfoundry.identity.uaa.error.ExceptionReport;
import org.cloudfoundry.identity.uaa.login.ConflictException;
import org.cloudfoundry.identity.uaa.login.ForgotPasswordInfo;
import org.cloudfoundry.identity.uaa.login.NotFoundException;
import org.cloudfoundry.identity.uaa.login.ResetPasswordService;
import org.cloudfoundry.identity.uaa.scim.ScimUser;
import org.cloudfoundry.identity.uaa.scim.endpoints.PasswordReset;
import org.cloudfoundry.identity.uaa.scim.exception.InvalidPasswordException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimException;
import org.cloudfoundry.identity.uaa.scim.exception.ScimResourceNotFoundException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.View;

@Controller
public class PasswordResetEndpoint {
    private final ResetPasswordService resetPasswordService;
    private HttpMessageConverter<?>[] messageConverters = new RestTemplate().getMessageConverters().toArray(new HttpMessageConverter[0]);

    public PasswordResetEndpoint(ResetPasswordService resetPasswordService) {
        this.resetPasswordService = resetPasswordService;
    }

    public void setMessageConverters(HttpMessageConverter<?>[] messageConverters) {
        this.messageConverters = messageConverters;
    }

    @RequestMapping(value={"/password_resets"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, String>> resetPassword(@RequestBody String email) throws IOException {
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            ForgotPasswordInfo forgotPasswordInfo = this.resetPasswordService.forgotPassword(email, "", "");
            response.put("code", forgotPasswordInfo.getResetPasswordCode().getCode());
            response.put("user_id", forgotPasswordInfo.getUserId());
            return new ResponseEntity(response, HttpStatus.CREATED);
        }
        catch (ConflictException e) {
            response.put("user_id", e.getUserId());
            return new ResponseEntity(response, HttpStatus.CONFLICT);
        }
        catch (NotFoundException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/password_change"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, String>> changePassword(@RequestBody PasswordReset passwordReset) {
        ResponseEntity<Map<String, String>> responseEntity = passwordReset.getCode() != null ? this.resetPassword(passwordReset.getCode(), passwordReset.getNewPassword()) : new ResponseEntity<Map<String, String>>(HttpStatus.BAD_REQUEST);
        return responseEntity;
    }

    private ResponseEntity<Map<String, String>> resetPassword(String code, String newPassword) {
        try {
            ResetPasswordService.ResetPasswordResponse response = this.resetPasswordService.resetPassword(code, newPassword);
            ScimUser user = response.getUser();
            HashMap<String, String> userInfo = new HashMap<String, String>();
            userInfo.put("user_id", user.getId());
            userInfo.put("username", user.getUserName());
            userInfo.put("email", user.getPrimaryEmail());
            return new ResponseEntity(userInfo, HttpStatus.OK);
        }
        catch (BadCredentialsException e) {
            return new ResponseEntity(HttpStatus.UNAUTHORIZED);
        }
        catch (ScimResourceNotFoundException e) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (InvalidPasswordException e) {
            throw e;
        }
        catch (Exception e) {
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ExceptionHandler(value={InvalidPasswordException.class})
    public View handleException(InvalidPasswordException t) throws ScimException {
        return new ConvertingExceptionView(new ResponseEntity((Object)new ExceptionReport((Exception)t, false), HttpStatus.UNPROCESSABLE_ENTITY), this.messageConverters);
    }
}

